package com.kreative.bitsnpicas.u8m;

public enum U8MNativeMapping {
	APPLE_II("Apple II", new int[]{
		// ASCII
		0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
		0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
		0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
		0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
		0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
		0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F,
		0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F,
		0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F,
		// MouseText
		0xF813, 0xF812, 0x1FBB0, 0x231B, 0x2713, 0x1FBB1, 0x1FBB4, 0x1FB81,
		0x2190, 0x2026, 0x2193, 0x2191, 0x2594, 0x21B2, 0x2589, 0x1FBB5,
		0x1FBB6, 0x1FBB7, 0x1FBB8, 0x2500, 0x1FB7C, 0x2192, 0x2592, 0x1FB90,
		0x1FBB9, 0x1FBBA, 0x2595, 0x25C6, 0x1FB80, 0x1FBBB, 0x1FBBC, 0x258F,
		// High ASCII
		0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
		0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
		0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
		0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F,
		0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F,
		0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F,
	}),
	PETSCII("PETSCII", new int[]{
		
	});
	
	private final String name;
	private final int[] toUnicode;
	
	private U8MNativeMapping(String name, int[] toUnicode) {
		this.name = name;
		this.toUnicode = toUnicode;
	}
	
	@Override
	public String toString() {
		return name;
	}
	
	public int getCodePoint(int i) {
		if (i >= 0 && i < toUnicode.length) {
			return toUnicode[i];
		} else {
			return 0;
		}
	}
	
	public void apply(U8MFile u) {
		for (int i = 0, n = toUnicode.length; i < n; i++) {
			int cp = toUnicode[i];
			if (cp > 0) {
				int gi = u.getUnicodeGlyphIndex(cp);
				if (gi > 0) {
					u.setNativeGlyphIndex(cp, gi);
				}
			}
		}
	}
}
