// Copyright 2021 Bloomberg Finance L.P
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include <google/protobuf/util/json_util.h>

#include <buildboxcommon_logging.h>
#include <buildboxcommon_protojsonutils.h>
#include <rumbad_stdoutwriter.h>

namespace rumbad {

void StdoutWriter::write(const std::vector<Message> &messages)
{
    google::protobuf::util::JsonPrintOptions options;
    buildboxcommon::jsonOptionsAlwaysPrintFieldsWithNoPresence(options);

    for (const auto &message : messages) {
        std::string json;
        auto status = google::protobuf::util::MessageToJsonString(
            message.data, &json, options);
        if (!status.ok()) {
            BUILDBOX_LOG_WARNING("Failed to write messages to stdout");
            return;
        }

        std::cout << json << std::endl;
    }
}

} // namespace rumbad
