import { Component } from 'react';
import { ToolbarGroupProps } from './ToolbarGroup';
export interface ToolbarToggleGroupProps extends ToolbarGroupProps {
    /** Flag indicating when toggle group is expanded for non-managed toolbar toggle groups. */
    isExpanded?: boolean;
    /** Callback for toggle group click event for non-managed toolbar toggle groups. */
    onToggle?: (event: React.MouseEvent) => void;
    /** An icon to be rendered when the toggle group has collapsed down */
    toggleIcon: React.ReactNode;
    /** Controls when filters are shown and when the toggle button is hidden. */
    breakpoint: 'md' | 'lg' | 'xl' | '2xl';
    /** Visibility at various breakpoints. */
    visibility?: {
        default?: 'hidden' | 'visible';
        md?: 'hidden' | 'visible';
        lg?: 'hidden' | 'visible';
        xl?: 'hidden' | 'visible';
        '2xl'?: 'hidden' | 'visible';
    };
    /** Sets both the column and row gap at various breakpoints. */
    gap?: {
        default?: 'gapNone' | 'gapXs' | 'gapSm' | 'gapMd' | 'gapLg' | 'gapXl' | 'gap_2xl' | 'gap_3xl' | 'gap_4xl';
        md?: 'gapNone' | 'gapXs' | 'gapSm' | 'gapMd' | 'gapLg' | 'gapXl' | 'gap_2xl' | 'gap_3xl' | 'gap_4xl';
        lg?: 'gapNone' | 'gapXs' | 'gapSm' | 'gapMd' | 'gapLg' | 'gapXl' | 'gap_2xl' | 'gap_3xl' | 'gap_4xl';
        xl?: 'gapNone' | 'gapXs' | 'gapSm' | 'gapMd' | 'gapLg' | 'gapXl' | 'gap_2xl' | 'gap_3xl' | 'gap_4xl';
        '2xl'?: 'gapNone' | 'gapXs' | 'gapSm' | 'gapMd' | 'gapLg' | 'gapXl' | 'gap_2xl' | 'gap_3xl' | 'gap_4xl';
    };
    /** Sets only the column gap at various breakpoints. */
    columnGap?: {
        default?: 'columnGapNone' | 'columnGapXs' | 'columnGapSm' | 'columnGapMd' | 'columnGapLg' | 'columnGapXl' | 'columnGap_2xl' | 'columnGap_3xl' | 'columnGap_4xl';
        md?: 'columnGapNone' | 'columnGapXs' | 'columnGapSm' | 'columnGapMd' | 'columnGapLg' | 'columnGapXl' | 'columnGap_2xl' | 'columnGap_3xl' | 'columnGap_4xl';
        lg?: 'columnGapNone' | 'columnGapXs' | 'columnGapSm' | 'columnGapMd' | 'columnGapLg' | 'columnGapXl' | 'columnGap_2xl' | 'columnGap_3xl' | 'columnGap_4xl';
        xl?: 'columnGapNone' | 'columnGapXs' | 'columnGapSm' | 'columnGapMd' | 'columnGapLg' | 'columnGapXl' | 'columnGap_2xl' | 'columnGap_3xl' | 'columnGap_4xl';
        '2xl'?: 'columnGapNone' | 'columnGapXs' | 'columnGapSm' | 'columnGapMd' | 'columnGapLg' | 'columnGapXl' | 'columnGap_2xl' | 'columnGap_3xl' | 'columnGap_4xl';
    };
    /** Sets only the row gap at various breakpoints. */
    rowGap?: {
        default?: 'rowGapNone' | 'rowGapXs' | 'rowGapSm' | 'rowGapMd' | 'rowGapLg' | 'rowGapXl' | 'rowGap_2xl' | 'rowGap_3xl' | 'rowGap_4xl';
        md?: 'rowGapNone' | 'rowGapXs' | 'rowGapSm' | 'rowGapMd' | 'rowGapLg' | 'rowGapXl' | 'rowGap_2xl' | 'rowGap_3xl' | 'rowGap_4xl';
        lg?: 'rowGapNone' | 'rowGapXs' | 'rowGapSm' | 'rowGapMd' | 'rowGapLg' | 'rowGapXl' | 'rowGap_2xl' | 'rowGap_3xl' | 'rowGap_4xl';
        xl?: 'rowGapNone' | 'rowGapXs' | 'rowGapSm' | 'rowGapMd' | 'rowGapLg' | 'rowGapXl' | 'rowGap_2xl' | 'rowGap_3xl' | 'rowGap_4xl';
        '2xl'?: 'rowGapNone' | 'rowGapXs' | 'rowGapSm' | 'rowGapMd' | 'rowGapLg' | 'rowGapXl' | 'rowGap_2xl' | 'rowGap_3xl' | 'rowGap_4xl';
    };
    /** Reference to a label container group for filters inside the toolbar toggle group */
    labelContainerRef?: React.RefObject<any>;
    /** Optional callback for clearing all filters in the toolbar toggle group */
    clearAllFilters?: () => void;
    /** Flag indicating that the clear all filters button should be visible in the toolbar toggle group */
    showClearFiltersButton?: boolean;
    /** Text to display in the clear all filters button of the toolbar toggle group */
    clearFiltersButtonText?: string;
}
declare class ToolbarToggleGroup extends Component<ToolbarToggleGroupProps> {
    static displayName: string;
    toggleRef: import("react").RefObject<HTMLButtonElement>;
    expandableContentRef: import("react").RefObject<HTMLDivElement>;
    isContentPopup: () => boolean;
    render(): import("react/jsx-runtime").JSX.Element;
}
export { ToolbarToggleGroup };
//# sourceMappingURL=ToolbarToggleGroup.d.ts.map