# widgets/navbar.py
#
# Copyright 2020-2025 Fabio Comuni, et al.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
from typing import Generator
from dataclasses import dataclass

from gi.repository import GObject
from gi.repository import Gtk


@Gtk.Template(resource_path="/net/kirgroup/confy/widgets/navbarlistitem.ui")
class NavbarListItem(Gtk.ListBoxRow):
    __gtype_name__ = "ConfyNavbarListItem"
    icon: str = GObject.Property(type=str, default="")
    label: str = GObject.Property(type=str, default="")
    group: int = GObject.Property(type=int, default=0)


@Gtk.Template(resource_path="/net/kirgroup/confy/widgets/navbar.ui")
class Navbar(Gtk.ListBox):
    __gtype_name__ = "ConfyNavbar"

    def __init__(self, **kwargs):
        super().__init__(**kwargs)
        # Just because I'm lazy:
        # set all chidldred of 'self' as self attribute
        # using template name (builder id)
        # this way I can add pages just in template and I'm done
        c = self.get_first_child()
        while c:
            name = c.get_buildable_id()
            if name:
                setattr(self, name, c)
            c = c.get_next_sibling()

    @GObject.Signal
    def page_changed(self):
        ...

