# Automation and continuous integration systems

Our Android projects share a similar automation model:
- Taskcluster is our primary CI: we use it for as much automation as
possible, including our core builds and releases, because it's a
flexible first party service we can rely on.
- GitHub Actions is secondary: it runs some regular tasks or a subset of tests for pull requests.

## Taskcluster

[Taskcluster][tc] is a generic task execution framework developed and used by Mozilla to automate continuous integration and release processes.

We currently use Taskcluster to:
* Build, test and run code tools for all master commits and pull requests
(including contributor PRs). See [Code quality tools](#code-quality-tools)
for additional information.
* Build (unsigned) release builds whenever a release is created on GitHub
* Automatically import new translations from the L10N repository.

To see a Taskcluster configuration for your project, see
`<project-root>/.taskcluster.yml` (here's an
[example in focus-android][tc yml]).

Taskcluster runs using docker: see our [docker guide](docker_guide.md) for
more information.

## GitHub Actions

[GitHub Actions][gha] is GitHub's own CI/CD service.

We currently use GitHub Actions to:
* Build, test and run code tools for pull requests (including contributor PRs).
* Automatically update dependencies & synchronize localization files
* Automatically adding additional labels to new issues

To see the GitHub Actions configuration for your project, see `<project-root>/.github/workflows` (here's an [example in Fenix][gha-fenix]).

You can find the workflows and builds logs under the "Actions" tab of each project.

# Code quality tools

For Kotlin only projects, run these tools:
* Android lint
* [detekt](https://github.com/arturbosch/detekt)
* [ktlint](https://github.com/shyiko/ktlint)

For projects that also include Java, add these tools:
* checkstyle
* findbugs
* PMD

To see what tools are currently run in automation for your project, see
the project's `<project-root>/.taskcluster.yml`
(here's an [example in focus-android][tc yml tools]).

# Third-party services

## Codecov

Codecov evaluates the code coverage reports generated by our build and tracks the coverage over time. It warns when merging pull requests would lead to dropping the coverage below a specified threshold.

* https://codecov.io/gh
* [focus-android code coverage over time](https://codecov.io/gh/mozilla-mobile/focus-android/branch/master)

# Automation tasks

## Pull request pipeline

![](https://i.imgur.com/SJ9zSs8.png)

## Release pipeline

Eventually we want to automate the whole release process pipeline in order to have "one click" releases without much workload for the engineering team.

### ✅ Active: Release builds

Whenever a release is created on GitHub, we build releases versions of the project on taskcluster (example: [focus-android configuration](https://github.com/mozilla-mobile/focus-android/blob/master/.taskcluster.yml#L91)).

### ✅ Active: Signing

Signing requires access to Mozilla's signing certificates. In addition to that a signing task needs to be able to validate the origin of the APK ("Can I trust the task that built the APK?") to avoid signing random tasks.

* [Chain of Trust](http://scriptworker.readthedocs.io/en/latest/chain_of_trust.html)
* [pushapkscript](https://github.com/mozilla-releng/pushapkscript)

### ✅ Active: Upload to archive.mozilla.org

Every release is published on archive.mozilla.org.  Nightly builds go to https://archive.mozilla.org/pub/fenix/nightly/ and https://archive.mozilla.org/pub/focus/nightly/.
Release builds are uploaded to https://archive.mozilla.org/pub/fenix/releases/ and https://archive.mozilla.org/pub/focus/releases/.

* [beetmover script](https://github.com/mozilla-releng/scriptworker-scripts/tree/master/beetmoverscript/)

### ✅ Active: Publish

Finally we want to publish a release build on Google Play

Like other scriptworker instances, we can use the existing instance. The current implementation is fennec-specific. We have to add support there too. pushapk_scriptworker mainly delegates checks and uploads to mozapkpublisher. That tool needs Focus support. Working on mozapkpublisher doesn't require any Taskcluster knowledge.

* [pushapkscript](https://github.com/mozilla-releng/scriptworker-scripts/tree/master/pushapkscript/)
* [mozapkpublisher](https://github.com/mozilla-releng/mozapkpublisher)

## Nightly (Alpha) pipeline

TODO: explain the current process

## Maintenance tasks

### ✅ Active: String import

Every day at 12:00 UTC we run a script that imports the latest translations from the L10N repository and creates a pull request for the import if there are new strings. Eventually this import can be merged automatically. For now we want to review those changes manually to validate that the task is running as intended.

We hope to improve this process soon.

* [Task script](https://github.com/mozilla-mobile/focus-android/blob/master/tools/taskcluster/import_strings_and_create_pull_request.sh)
* [Hook and task definition](https://tools.taskcluster.net/hooks/project-focus/strings-import)

[tc yml]: https://github.com/mozilla-mobile/focus-android/blob/master/.taskcluster.yml
[tc yml tools]: https://github.com/mozilla-mobile/focus-android/blob/38f79e25493ab08b8322cd4c059891f37fbf500f/.taskcluster.yml#L39
[tc]: https://docs.taskcluster.net/docs
[gha]: https://github.com/features/actions
[gha-fenix]: https://github.com/mozilla-mobile/fenix/tree/main/.github/workflows
