import { Data } from "@ot-builder/prelude";
export declare class ListStoreFactory<T> implements Data.OrderStoreFactory<T, ListStore<T>> {
    private readonly sourceKind;
    constructor(sourceKind: string);
    createStoreFromList(items: Iterable<T>): ListStore<T>;
}
export declare class ListStoreFactoryWithDefault<T> extends ListStoreFactory<T> implements Data.OrderStoreFactoryWithDefault<T, ListStore<T>> {
    private readonly create;
    constructor(sourceKind: string, create: () => T);
    createStoreFromSize(count: number): ListStore<T>;
}
export declare class ListStore<T> implements Data.OrderStore<T> {
    private readonly sourceKind;
    readonly items: Array<T>;
    constructor(sourceKind: string, items: Array<T>);
    decideOrder(): Data.Order<T>;
}
export declare function fromList<T>(sourceKind: string, a: ReadonlyArray<T>): Data.Order<T>;
//# sourceMappingURL=index.d.ts.map