"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoalBuilder = GoalBuilder;
exports.MakeGoalBuilder = MakeGoalBuilder;
exports.SinglePlural_F = SinglePlural_F;
exports.SinglePlural_T = SinglePlural_T;
const matchers_1 = require("./matchers");
function GoalBuilder(matcher, rule) {
    return function (literals, ...placeholders) {
        if (typeof literals === "string") {
            const ob = matcher.createGoalIdFromArgs([literals]);
            return { ...ob, rule };
        }
        else {
            let result = "";
            for (let i = 0; i < placeholders.length; i++) {
                result += literals[i];
                result += placeholders[i];
            }
            result += literals[literals.length - 1];
            const ob = matcher.createGoalIdFromArgs([result]);
            return { ...ob, rule };
        }
    };
}
function MakeGoalBuilder(matcher, rule) {
    return function (...args) {
        return { ...matcher.createGoalIdFromArgs(args), rule };
    };
}
function SinglePlural_F(rulePrefix, dir, cfg, RuleBuilder) {
    const glob = function (pattern, FRecipe) {
        const matcher = new matchers_1.KindMatcherT(rulePrefix, new matchers_1.FilePathMatcherT(cfg, new matchers_1.GlobMatcher(pattern)));
        const rule = RuleBuilder(matcher, FRecipe);
        dir.addRule(rule);
        return GoalBuilder(matcher, rule);
    };
    const exact = function (pattern, FRecipe) {
        const matcher = new matchers_1.KindMatcherT(rulePrefix, new matchers_1.FilePathMatcherT(cfg, new matchers_1.ExactMatcher(pattern)));
        const rule = RuleBuilder(matcher, FRecipe);
        dir.addRule(rule);
        return GoalBuilder(matcher, rule)(pattern);
    };
    const make = function (mk, FRecipe) {
        const matcher = new matchers_1.KindMatcherT(rulePrefix, new matchers_1.FilePathMatcherT(cfg, new matchers_1.MakeMatcher(mk)));
        const rule = RuleBuilder(matcher, FRecipe);
        dir.addRule(rule);
        return MakeGoalBuilder(matcher, rule);
    };
    return { glob, exact, make };
}
function SinglePlural_T(rulePrefix, dir, RuleBuilder) {
    const glob = function (pattern, FRecipe) {
        const matcher = new matchers_1.KindMatcherT(rulePrefix, new matchers_1.GlobMatcher(pattern));
        const rule = RuleBuilder(matcher, FRecipe);
        dir.addRule(rule);
        return GoalBuilder(matcher, rule);
    };
    const exact = function (pattern, FRecipe) {
        const matcher = new matchers_1.KindMatcherT(rulePrefix, new matchers_1.ExactMatcher(pattern));
        const rule = RuleBuilder(matcher, FRecipe);
        dir.addRule(rule);
        return GoalBuilder(matcher, rule)(pattern);
    };
    const subPrefix = function (_subPrefix, FRecipe) {
        const subPrefix = _subPrefix + "::";
        const matcher = new matchers_1.KindMatcherT(rulePrefix, new matchers_1.PrefixMatcherT(subPrefix, new matchers_1.AlwaysMatcher()));
        const rule = RuleBuilder(matcher, FRecipe);
        dir.addRule(rule);
        return GoalBuilder(matcher, rule);
    };
    const make = function (mk, FRecipe) {
        const matcher = new matchers_1.KindMatcherT(rulePrefix, new matchers_1.MakeMatcher(mk));
        const rule = RuleBuilder(matcher, FRecipe);
        dir.addRule(rule);
        return MakeGoalBuilder(matcher, rule);
    };
    return { glob, exact, subPrefix, make };
}
