# frozen_string_literal: true

class AddIndexForInitialAndLatestPipelineIdToVulnerabilityOccurrences < Gitlab::Database::Migration[2.2]
  milestone '16.10'

  disable_ddl_transaction!

  TABLE_NAME = :vulnerability_occurrences
  INITIAL_PIPELINE_INDEX = 'index_vulnerability_occurrences_on_initial_pipeline_id'
  LATEST_PIPELINE_INDEX = 'index_vulnerability_occurrences_on_latest_pipeline_id'

  def up
    add_concurrent_index TABLE_NAME, :initial_pipeline_id, name: INITIAL_PIPELINE_INDEX
    add_concurrent_index TABLE_NAME, :latest_pipeline_id, name: LATEST_PIPELINE_INDEX
  end

  def down
    remove_concurrent_index_by_name TABLE_NAME, INITIAL_PIPELINE_INDEX
    remove_concurrent_index_by_name TABLE_NAME, LATEST_PIPELINE_INDEX
  end
end
