//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armreservations_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/reservations/armreservations/v3"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/GetCatalog.json
func ExampleAzureReservationAPIClient_NewGetCatalogPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armreservations.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAzureReservationAPIClient().NewGetCatalogPager("23bc208b-083f-4901-ae85-4f98c0c3b4b6", &armreservations.AzureReservationAPIClientGetCatalogOptions{ReservedResourceType: to.Ptr("VirtualMachines"),
		Location:    to.Ptr("eastus"),
		PublisherID: nil,
		OfferID:     nil,
		PlanID:      nil,
		Filter:      nil,
		Skip:        nil,
		Take:        nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.CatalogsResult = armreservations.CatalogsResult{
		// 	TotalItems: to.Ptr[int64](1000),
		// 	Value: []*armreservations.Catalog{
		// 		{
		// 			Name: to.Ptr("Standard_DS5_v2"),
		// 			BillingPlans: map[string][]*armreservations.ReservationBillingPlan{
		// 				"P1Y": []*armreservations.ReservationBillingPlan{
		// 					to.Ptr(armreservations.ReservationBillingPlanUpfront),
		// 					to.Ptr(armreservations.ReservationBillingPlanMonthly)},
		// 					"P3Y": []*armreservations.ReservationBillingPlan{
		// 						to.Ptr(armreservations.ReservationBillingPlanUpfront),
		// 						to.Ptr(armreservations.ReservationBillingPlanMonthly)},
		// 					},
		// 					Locations: []*string{
		// 						to.Ptr("eastus")},
		// 						ResourceType: to.Ptr("VirtualMachines"),
		// 						Restrictions: []*armreservations.SKURestriction{
		// 						},
		// 						SKUProperties: []*armreservations.SKUProperty{
		// 							{
		// 								Name: to.Ptr("Cores"),
		// 								Value: to.Ptr("16"),
		// 							},
		// 							{
		// 								Name: to.Ptr("ProductTitle"),
		// 								Value: to.Ptr("DSv2 Series, DS5"),
		// 							},
		// 							{
		// 								Name: to.Ptr("ProductShortName"),
		// 								Value: to.Ptr("DSv2 Series"),
		// 							},
		// 							{
		// 								Name: to.Ptr("SKUName"),
		// 								Value: to.Ptr("DS5 v2"),
		// 							},
		// 							{
		// 								Name: to.Ptr("MeterId"),
		// 								Value: to.Ptr("12bc208b-083f-4901-ae85-4f98c0c3b4b8"),
		// 						}},
		// 						Terms: []*armreservations.ReservationTerm{
		// 							to.Ptr(armreservations.ReservationTermP1Y),
		// 							to.Ptr(armreservations.ReservationTermP3Y)},
		// 						},
		// 						{
		// 							Name: to.Ptr("Standard_D1"),
		// 							BillingPlans: map[string][]*armreservations.ReservationBillingPlan{
		// 								"P1Y": []*armreservations.ReservationBillingPlan{
		// 									to.Ptr(armreservations.ReservationBillingPlanUpfront),
		// 									to.Ptr(armreservations.ReservationBillingPlanMonthly)},
		// 									"P3Y": []*armreservations.ReservationBillingPlan{
		// 										to.Ptr(armreservations.ReservationBillingPlanUpfront),
		// 										to.Ptr(armreservations.ReservationBillingPlanMonthly)},
		// 									},
		// 									Locations: []*string{
		// 										to.Ptr("eastus")},
		// 										ResourceType: to.Ptr("VirtualMachines"),
		// 										Restrictions: []*armreservations.SKURestriction{
		// 											{
		// 												Type: to.Ptr("Term"),
		// 												ReasonCode: to.Ptr("NotAvailableForSubscription"),
		// 												Values: []*string{
		// 													to.Ptr("P1Y")},
		// 												},
		// 												{
		// 													Type: to.Ptr("Term"),
		// 													ReasonCode: to.Ptr("NotAvailableForSubscription"),
		// 													Values: []*string{
		// 														to.Ptr("P3Y")},
		// 												}},
		// 												SKUProperties: []*armreservations.SKUProperty{
		// 													{
		// 														Name: to.Ptr("Cores"),
		// 														Value: to.Ptr("1"),
		// 													},
		// 													{
		// 														Name: to.Ptr("ProductTitle"),
		// 														Value: to.Ptr("D Series, D1"),
		// 													},
		// 													{
		// 														Name: to.Ptr("ProductShortName"),
		// 														Value: to.Ptr("D Series"),
		// 													},
		// 													{
		// 														Name: to.Ptr("SKUName"),
		// 														Value: to.Ptr("D1"),
		// 													},
		// 													{
		// 														Name: to.Ptr("MeterId"),
		// 														Value: to.Ptr("12bc208b-083f-4901-ae85-4f98c0c3b4b8"),
		// 												}},
		// 												Terms: []*armreservations.ReservationTerm{
		// 													to.Ptr(armreservations.ReservationTermP1Y),
		// 													to.Ptr(armreservations.ReservationTermP3Y)},
		// 												},
		// 												{
		// 													Name: to.Ptr("Standard_F2"),
		// 													BillingPlans: map[string][]*armreservations.ReservationBillingPlan{
		// 														"P1Y": []*armreservations.ReservationBillingPlan{
		// 															to.Ptr(armreservations.ReservationBillingPlanUpfront),
		// 															to.Ptr(armreservations.ReservationBillingPlanMonthly)},
		// 															"P3Y": []*armreservations.ReservationBillingPlan{
		// 																to.Ptr(armreservations.ReservationBillingPlanUpfront),
		// 																to.Ptr(armreservations.ReservationBillingPlanMonthly)},
		// 															},
		// 															Locations: []*string{
		// 																to.Ptr("eastus")},
		// 																ResourceType: to.Ptr("VirtualMachines"),
		// 																Restrictions: []*armreservations.SKURestriction{
		// 																	{
		// 																		Type: to.Ptr("Location"),
		// 																		ReasonCode: to.Ptr("NotAvailableForSubscription"),
		// 																		Values: []*string{
		// 																			to.Ptr("eastus")},
		// 																	}},
		// 																	SKUProperties: []*armreservations.SKUProperty{
		// 																		{
		// 																			Name: to.Ptr("Cores"),
		// 																			Value: to.Ptr("2"),
		// 																		},
		// 																		{
		// 																			Name: to.Ptr("ProductTitle"),
		// 																			Value: to.Ptr("F Series, F2"),
		// 																		},
		// 																		{
		// 																			Name: to.Ptr("ProductShortName"),
		// 																			Value: to.Ptr("F Series"),
		// 																		},
		// 																		{
		// 																			Name: to.Ptr("SKUName"),
		// 																			Value: to.Ptr("F2"),
		// 																		},
		// 																		{
		// 																			Name: to.Ptr("MeterId"),
		// 																			Value: to.Ptr("12bc208b-083f-4901-ae85-4f98c0c3b4b8"),
		// 																	}},
		// 																	Terms: []*armreservations.ReservationTerm{
		// 																		to.Ptr(armreservations.ReservationTermP1Y),
		// 																		to.Ptr(armreservations.ReservationTermP3Y)},
		// 																}},
		// 															}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/GetAppliedReservations.json
func ExampleAzureReservationAPIClient_GetAppliedReservationList() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armreservations.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAzureReservationAPIClient().GetAppliedReservationList(ctx, "23bc208b-083f-4901-ae85-4f98c0c3b4b6", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AppliedReservations = armreservations.AppliedReservations{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Capacity/AppliedReservations"),
	// 	ID: to.Ptr("/subscriptions/23bc208b-083f-4901-ae85-4f98c0c3b4b6/providers/microsoft.capacity/AppliedReservations/default"),
	// 	Properties: &armreservations.AppliedReservationsProperties{
	// 		ReservationOrderIDs: &armreservations.AppliedReservationList{
	// 			Value: []*string{
	// 				to.Ptr("/providers/Microsoft.Capacity/reservationorders/e1eccf0b-2db4-4e84-97e7-98b50e9d46f7"),
	// 				to.Ptr("/providers/Microsoft.Capacity/reservationorders/741a32eb-6158-4cee-9642-a0243ae79fac"),
	// 				to.Ptr("/providers/Microsoft.Capacity/reservationorders/e061223d-fcff-4d10-bd49-56a740cfb96a"),
	// 				to.Ptr("/providers/Microsoft.Capacity/reservationorders/2eeb7234-970e-4663-b60b-85241b515901"),
	// 				to.Ptr("/providers/Microsoft.Capacity/reservationorders/9db2f4c5-b1c5-42a8-bd79-ee56cdde2c7f"),
	// 				to.Ptr("/providers/Microsoft.Capacity/reservationorders/5da7a877-6d6e-44af-8880-ed3f533bf928"),
	// 				to.Ptr("/providers/Microsoft.Capacity/reservationorders/f65b0d0a-f945-4105-821c-d00bc8bacde8"),
	// 				to.Ptr("/providers/Microsoft.Capacity/reservationorders/51304124-e477-4b07-b9fa-03b05c8b924b"),
	// 				to.Ptr("/providers/Microsoft.Capacity/reservationorders/f5409b98-8a42-4dc6-be0a-cc59bef4d0db"),
	// 				to.Ptr("/providers/Microsoft.Capacity/reservationorders/a495550a-80a4-46f8-8843-34d4df46f9a6"),
	// 				to.Ptr("/providers/Microsoft.Capacity/reservationorders/1a966e18-c272-4ce1-a0c2-d4e1039023c3"),
	// 				to.Ptr("/providers/Microsoft.Capacity/reservationorders/939310b4-f9de-4645-9569-ab5b6cfe958e"),
	// 				to.Ptr("/providers/Microsoft.Capacity/reservationorders/4193a889-7c3b-44dc-8b7b-bfd7aad6c723")},
	// 			},
	// 		},
	// 	}
}
