//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// SubscriptionUsagesServer is a fake server for instances of the armsql.SubscriptionUsagesClient type.
type SubscriptionUsagesServer struct {
	// Get is the fake for method SubscriptionUsagesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, locationName string, usageName string, options *armsql.SubscriptionUsagesClientGetOptions) (resp azfake.Responder[armsql.SubscriptionUsagesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByLocationPager is the fake for method SubscriptionUsagesClient.NewListByLocationPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByLocationPager func(locationName string, options *armsql.SubscriptionUsagesClientListByLocationOptions) (resp azfake.PagerResponder[armsql.SubscriptionUsagesClientListByLocationResponse])
}

// NewSubscriptionUsagesServerTransport creates a new instance of SubscriptionUsagesServerTransport with the provided implementation.
// The returned SubscriptionUsagesServerTransport instance is connected to an instance of armsql.SubscriptionUsagesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSubscriptionUsagesServerTransport(srv *SubscriptionUsagesServer) *SubscriptionUsagesServerTransport {
	return &SubscriptionUsagesServerTransport{
		srv:                    srv,
		newListByLocationPager: newTracker[azfake.PagerResponder[armsql.SubscriptionUsagesClientListByLocationResponse]](),
	}
}

// SubscriptionUsagesServerTransport connects instances of armsql.SubscriptionUsagesClient to instances of SubscriptionUsagesServer.
// Don't use this type directly, use NewSubscriptionUsagesServerTransport instead.
type SubscriptionUsagesServerTransport struct {
	srv                    *SubscriptionUsagesServer
	newListByLocationPager *tracker[azfake.PagerResponder[armsql.SubscriptionUsagesClientListByLocationResponse]]
}

// Do implements the policy.Transporter interface for SubscriptionUsagesServerTransport.
func (s *SubscriptionUsagesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SubscriptionUsagesClient.Get":
		resp, err = s.dispatchGet(req)
	case "SubscriptionUsagesClient.NewListByLocationPager":
		resp, err = s.dispatchNewListByLocationPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SubscriptionUsagesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/usages/(?P<usageName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
	if err != nil {
		return nil, err
	}
	usageNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("usageName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), locationNameParam, usageNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SubscriptionUsage, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SubscriptionUsagesServerTransport) dispatchNewListByLocationPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListByLocationPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByLocationPager not implemented")}
	}
	newListByLocationPager := s.newListByLocationPager.get(req)
	if newListByLocationPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/usages`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListByLocationPager(locationNameParam, nil)
		newListByLocationPager = &resp
		s.newListByLocationPager.add(req, newListByLocationPager)
		server.PagerResponderInjectNextLinks(newListByLocationPager, req, func(page *armsql.SubscriptionUsagesClientListByLocationResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByLocationPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListByLocationPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByLocationPager) {
		s.newListByLocationPager.remove(req)
	}
	return resp, nil
}
