//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// VulnerabilityAssessmentExecuteScanServer is a fake server for instances of the armsql.VulnerabilityAssessmentExecuteScanClient type.
type VulnerabilityAssessmentExecuteScanServer struct {
	// BeginExecute is the fake for method VulnerabilityAssessmentExecuteScanClient.BeginExecute
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginExecute func(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName armsql.VulnerabilityAssessmentName, options *armsql.VulnerabilityAssessmentExecuteScanClientBeginExecuteOptions) (resp azfake.PollerResponder[armsql.VulnerabilityAssessmentExecuteScanClientExecuteResponse], errResp azfake.ErrorResponder)
}

// NewVulnerabilityAssessmentExecuteScanServerTransport creates a new instance of VulnerabilityAssessmentExecuteScanServerTransport with the provided implementation.
// The returned VulnerabilityAssessmentExecuteScanServerTransport instance is connected to an instance of armsql.VulnerabilityAssessmentExecuteScanClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewVulnerabilityAssessmentExecuteScanServerTransport(srv *VulnerabilityAssessmentExecuteScanServer) *VulnerabilityAssessmentExecuteScanServerTransport {
	return &VulnerabilityAssessmentExecuteScanServerTransport{
		srv:          srv,
		beginExecute: newTracker[azfake.PollerResponder[armsql.VulnerabilityAssessmentExecuteScanClientExecuteResponse]](),
	}
}

// VulnerabilityAssessmentExecuteScanServerTransport connects instances of armsql.VulnerabilityAssessmentExecuteScanClient to instances of VulnerabilityAssessmentExecuteScanServer.
// Don't use this type directly, use NewVulnerabilityAssessmentExecuteScanServerTransport instead.
type VulnerabilityAssessmentExecuteScanServerTransport struct {
	srv          *VulnerabilityAssessmentExecuteScanServer
	beginExecute *tracker[azfake.PollerResponder[armsql.VulnerabilityAssessmentExecuteScanClientExecuteResponse]]
}

// Do implements the policy.Transporter interface for VulnerabilityAssessmentExecuteScanServerTransport.
func (v *VulnerabilityAssessmentExecuteScanServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "VulnerabilityAssessmentExecuteScanClient.BeginExecute":
		resp, err = v.dispatchBeginExecute(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (v *VulnerabilityAssessmentExecuteScanServerTransport) dispatchBeginExecute(req *http.Request) (*http.Response, error) {
	if v.srv.BeginExecute == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginExecute not implemented")}
	}
	beginExecute := v.beginExecute.get(req)
	if beginExecute == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlVulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/initiateScan`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.VulnerabilityAssessmentName, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armsql.VulnerabilityAssessmentName(p), nil
		})
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginExecute(req.Context(), resourceGroupNameParam, serverNameParam, vulnerabilityAssessmentNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginExecute = &respr
		v.beginExecute.add(req, beginExecute)
	}

	resp, err := server.PollerResponderNext(beginExecute, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginExecute.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginExecute) {
		v.beginExecute.remove(req)
	}

	return resp, nil
}
