//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsynapse

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// SQLPoolVulnerabilityAssessmentScansClient contains the methods for the SQLPoolVulnerabilityAssessmentScans group.
// Don't use this type directly, use NewSQLPoolVulnerabilityAssessmentScansClient() instead.
type SQLPoolVulnerabilityAssessmentScansClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewSQLPoolVulnerabilityAssessmentScansClient creates a new instance of SQLPoolVulnerabilityAssessmentScansClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewSQLPoolVulnerabilityAssessmentScansClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*SQLPoolVulnerabilityAssessmentScansClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &SQLPoolVulnerabilityAssessmentScansClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Export - Convert an existing scan result to a human readable format. If already exists nothing happens
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-06-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the workspace.
//   - sqlPoolName - SQL pool name
//   - vulnerabilityAssessmentName - The name of the vulnerability assessment.
//   - scanID - The vulnerability assessment scan Id of the scan to retrieve.
//   - options - SQLPoolVulnerabilityAssessmentScansClientExportOptions contains the optional parameters for the SQLPoolVulnerabilityAssessmentScansClient.Export
//     method.
func (client *SQLPoolVulnerabilityAssessmentScansClient) Export(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, scanID string, options *SQLPoolVulnerabilityAssessmentScansClientExportOptions) (SQLPoolVulnerabilityAssessmentScansClientExportResponse, error) {
	var err error
	const operationName = "SQLPoolVulnerabilityAssessmentScansClient.Export"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.exportCreateRequest(ctx, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName, scanID, options)
	if err != nil {
		return SQLPoolVulnerabilityAssessmentScansClientExportResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SQLPoolVulnerabilityAssessmentScansClientExportResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return SQLPoolVulnerabilityAssessmentScansClientExportResponse{}, err
	}
	resp, err := client.exportHandleResponse(httpResp)
	return resp, err
}

// exportCreateRequest creates the Export request.
func (client *SQLPoolVulnerabilityAssessmentScansClient) exportCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, scanID string, options *SQLPoolVulnerabilityAssessmentScansClientExportOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/export"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if sqlPoolName == "" {
		return nil, errors.New("parameter sqlPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sqlPoolName}", url.PathEscape(sqlPoolName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if scanID == "" {
		return nil, errors.New("parameter scanID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scanId}", url.PathEscape(scanID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// exportHandleResponse handles the Export response.
func (client *SQLPoolVulnerabilityAssessmentScansClient) exportHandleResponse(resp *http.Response) (SQLPoolVulnerabilityAssessmentScansClientExportResponse, error) {
	result := SQLPoolVulnerabilityAssessmentScansClientExportResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SQLPoolVulnerabilityAssessmentScansExport); err != nil {
		return SQLPoolVulnerabilityAssessmentScansClientExportResponse{}, err
	}
	return result, nil
}

// Get - Gets a vulnerability assessment scan record of a Sql pool.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-06-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the workspace.
//   - sqlPoolName - SQL pool name
//   - vulnerabilityAssessmentName - The name of the vulnerability assessment.
//   - scanID - The vulnerability assessment scan Id of the scan to retrieve.
//   - options - SQLPoolVulnerabilityAssessmentScansClientGetOptions contains the optional parameters for the SQLPoolVulnerabilityAssessmentScansClient.Get
//     method.
func (client *SQLPoolVulnerabilityAssessmentScansClient) Get(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, scanID string, options *SQLPoolVulnerabilityAssessmentScansClientGetOptions) (SQLPoolVulnerabilityAssessmentScansClientGetResponse, error) {
	var err error
	const operationName = "SQLPoolVulnerabilityAssessmentScansClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName, scanID, options)
	if err != nil {
		return SQLPoolVulnerabilityAssessmentScansClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SQLPoolVulnerabilityAssessmentScansClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SQLPoolVulnerabilityAssessmentScansClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *SQLPoolVulnerabilityAssessmentScansClient) getCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, scanID string, options *SQLPoolVulnerabilityAssessmentScansClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if sqlPoolName == "" {
		return nil, errors.New("parameter sqlPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sqlPoolName}", url.PathEscape(sqlPoolName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if scanID == "" {
		return nil, errors.New("parameter scanID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scanId}", url.PathEscape(scanID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *SQLPoolVulnerabilityAssessmentScansClient) getHandleResponse(resp *http.Response) (SQLPoolVulnerabilityAssessmentScansClientGetResponse, error) {
	result := SQLPoolVulnerabilityAssessmentScansClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VulnerabilityAssessmentScanRecord); err != nil {
		return SQLPoolVulnerabilityAssessmentScansClientGetResponse{}, err
	}
	return result, nil
}

// BeginInitiateScan - Executes a Vulnerability Assessment database scan.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-06-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the workspace.
//   - sqlPoolName - SQL pool name
//   - vulnerabilityAssessmentName - The name of the vulnerability assessment.
//   - scanID - The vulnerability assessment scan Id of the scan to retrieve.
//   - options - SQLPoolVulnerabilityAssessmentScansClientBeginInitiateScanOptions contains the optional parameters for the SQLPoolVulnerabilityAssessmentScansClient.BeginInitiateScan
//     method.
func (client *SQLPoolVulnerabilityAssessmentScansClient) BeginInitiateScan(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, scanID string, options *SQLPoolVulnerabilityAssessmentScansClientBeginInitiateScanOptions) (*runtime.Poller[SQLPoolVulnerabilityAssessmentScansClientInitiateScanResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.initiateScan(ctx, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName, scanID, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[SQLPoolVulnerabilityAssessmentScansClientInitiateScanResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[SQLPoolVulnerabilityAssessmentScansClientInitiateScanResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// InitiateScan - Executes a Vulnerability Assessment database scan.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-06-01
func (client *SQLPoolVulnerabilityAssessmentScansClient) initiateScan(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, scanID string, options *SQLPoolVulnerabilityAssessmentScansClientBeginInitiateScanOptions) (*http.Response, error) {
	var err error
	const operationName = "SQLPoolVulnerabilityAssessmentScansClient.BeginInitiateScan"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.initiateScanCreateRequest(ctx, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName, scanID, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// initiateScanCreateRequest creates the InitiateScan request.
func (client *SQLPoolVulnerabilityAssessmentScansClient) initiateScanCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, scanID string, options *SQLPoolVulnerabilityAssessmentScansClientBeginInitiateScanOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/initiateScan"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if sqlPoolName == "" {
		return nil, errors.New("parameter sqlPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sqlPoolName}", url.PathEscape(sqlPoolName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if scanID == "" {
		return nil, errors.New("parameter scanID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scanId}", url.PathEscape(scanID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// NewListPager - Lists the vulnerability assessment scans of a SQL pool.
//
// Generated from API version 2021-06-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the workspace.
//   - sqlPoolName - SQL pool name
//   - vulnerabilityAssessmentName - The name of the vulnerability assessment.
//   - options - SQLPoolVulnerabilityAssessmentScansClientListOptions contains the optional parameters for the SQLPoolVulnerabilityAssessmentScansClient.NewListPager
//     method.
func (client *SQLPoolVulnerabilityAssessmentScansClient) NewListPager(resourceGroupName string, workspaceName string, sqlPoolName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, options *SQLPoolVulnerabilityAssessmentScansClientListOptions) *runtime.Pager[SQLPoolVulnerabilityAssessmentScansClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[SQLPoolVulnerabilityAssessmentScansClientListResponse]{
		More: func(page SQLPoolVulnerabilityAssessmentScansClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SQLPoolVulnerabilityAssessmentScansClientListResponse) (SQLPoolVulnerabilityAssessmentScansClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "SQLPoolVulnerabilityAssessmentScansClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName, options)
			}, nil)
			if err != nil {
				return SQLPoolVulnerabilityAssessmentScansClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *SQLPoolVulnerabilityAssessmentScansClient) listCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, options *SQLPoolVulnerabilityAssessmentScansClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if sqlPoolName == "" {
		return nil, errors.New("parameter sqlPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sqlPoolName}", url.PathEscape(sqlPoolName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *SQLPoolVulnerabilityAssessmentScansClient) listHandleResponse(resp *http.Response) (SQLPoolVulnerabilityAssessmentScansClientListResponse, error) {
	result := SQLPoolVulnerabilityAssessmentScansClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VulnerabilityAssessmentScanRecordListResult); err != nil {
		return SQLPoolVulnerabilityAssessmentScansClientListResponse{}, err
	}
	return result, nil
}
