// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
///////////////////////////////////////////////////////////////////////////////

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v3.21.12
// source: slh_dsa.proto

package slh_dsa_proto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type SlhDsaHashType int32

const (
	SlhDsaHashType_SLH_DSA_HASH_TYPE_UNSPECIFIED SlhDsaHashType = 0
	SlhDsaHashType_SHA2                          SlhDsaHashType = 1
	SlhDsaHashType_SHAKE                         SlhDsaHashType = 2
)

// Enum value maps for SlhDsaHashType.
var (
	SlhDsaHashType_name = map[int32]string{
		0: "SLH_DSA_HASH_TYPE_UNSPECIFIED",
		1: "SHA2",
		2: "SHAKE",
	}
	SlhDsaHashType_value = map[string]int32{
		"SLH_DSA_HASH_TYPE_UNSPECIFIED": 0,
		"SHA2":                          1,
		"SHAKE":                         2,
	}
)

func (x SlhDsaHashType) Enum() *SlhDsaHashType {
	p := new(SlhDsaHashType)
	*p = x
	return p
}

func (x SlhDsaHashType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SlhDsaHashType) Descriptor() protoreflect.EnumDescriptor {
	return file_slh_dsa_proto_enumTypes[0].Descriptor()
}

func (SlhDsaHashType) Type() protoreflect.EnumType {
	return &file_slh_dsa_proto_enumTypes[0]
}

func (x SlhDsaHashType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SlhDsaHashType.Descriptor instead.
func (SlhDsaHashType) EnumDescriptor() ([]byte, []int) {
	return file_slh_dsa_proto_rawDescGZIP(), []int{0}
}

type SlhDsaSignatureType int32

const (
	SlhDsaSignatureType_SLH_DSA_SIGNATURE_TYPE_UNSPECIFIED SlhDsaSignatureType = 0
	SlhDsaSignatureType_FAST_SIGNING                       SlhDsaSignatureType = 1
	SlhDsaSignatureType_SMALL_SIGNATURE                    SlhDsaSignatureType = 2
)

// Enum value maps for SlhDsaSignatureType.
var (
	SlhDsaSignatureType_name = map[int32]string{
		0: "SLH_DSA_SIGNATURE_TYPE_UNSPECIFIED",
		1: "FAST_SIGNING",
		2: "SMALL_SIGNATURE",
	}
	SlhDsaSignatureType_value = map[string]int32{
		"SLH_DSA_SIGNATURE_TYPE_UNSPECIFIED": 0,
		"FAST_SIGNING":                       1,
		"SMALL_SIGNATURE":                    2,
	}
)

func (x SlhDsaSignatureType) Enum() *SlhDsaSignatureType {
	p := new(SlhDsaSignatureType)
	*p = x
	return p
}

func (x SlhDsaSignatureType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SlhDsaSignatureType) Descriptor() protoreflect.EnumDescriptor {
	return file_slh_dsa_proto_enumTypes[1].Descriptor()
}

func (SlhDsaSignatureType) Type() protoreflect.EnumType {
	return &file_slh_dsa_proto_enumTypes[1]
}

func (x SlhDsaSignatureType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SlhDsaSignatureType.Descriptor instead.
func (SlhDsaSignatureType) EnumDescriptor() ([]byte, []int) {
	return file_slh_dsa_proto_rawDescGZIP(), []int{1}
}

// Protos for the Stateless Hash-Based Digital Signature Algorithm
// https://csrc.nist.gov/pubs/fips/205/final
type SlhDsaParams struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Required
	KeySize int32 `protobuf:"varint,1,opt,name=key_size,json=keySize,proto3" json:"key_size,omitempty"`
	// Required.
	HashType SlhDsaHashType `protobuf:"varint,2,opt,name=hash_type,json=hashType,proto3,enum=google.crypto.tink.SlhDsaHashType" json:"hash_type,omitempty"`
	// Required.
	SigType       SlhDsaSignatureType `protobuf:"varint,3,opt,name=sig_type,json=sigType,proto3,enum=google.crypto.tink.SlhDsaSignatureType" json:"sig_type,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SlhDsaParams) Reset() {
	*x = SlhDsaParams{}
	mi := &file_slh_dsa_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SlhDsaParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SlhDsaParams) ProtoMessage() {}

func (x *SlhDsaParams) ProtoReflect() protoreflect.Message {
	mi := &file_slh_dsa_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SlhDsaParams.ProtoReflect.Descriptor instead.
func (*SlhDsaParams) Descriptor() ([]byte, []int) {
	return file_slh_dsa_proto_rawDescGZIP(), []int{0}
}

func (x *SlhDsaParams) GetKeySize() int32 {
	if x != nil {
		return x.KeySize
	}
	return 0
}

func (x *SlhDsaParams) GetHashType() SlhDsaHashType {
	if x != nil {
		return x.HashType
	}
	return SlhDsaHashType_SLH_DSA_HASH_TYPE_UNSPECIFIED
}

func (x *SlhDsaParams) GetSigType() SlhDsaSignatureType {
	if x != nil {
		return x.SigType
	}
	return SlhDsaSignatureType_SLH_DSA_SIGNATURE_TYPE_UNSPECIFIED
}

type SlhDsaKeyFormat struct {
	state   protoimpl.MessageState `protogen:"open.v1"`
	Version uint32                 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// Required.
	Params        *SlhDsaParams `protobuf:"bytes,2,opt,name=params,proto3" json:"params,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SlhDsaKeyFormat) Reset() {
	*x = SlhDsaKeyFormat{}
	mi := &file_slh_dsa_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SlhDsaKeyFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SlhDsaKeyFormat) ProtoMessage() {}

func (x *SlhDsaKeyFormat) ProtoReflect() protoreflect.Message {
	mi := &file_slh_dsa_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SlhDsaKeyFormat.ProtoReflect.Descriptor instead.
func (*SlhDsaKeyFormat) Descriptor() ([]byte, []int) {
	return file_slh_dsa_proto_rawDescGZIP(), []int{1}
}

func (x *SlhDsaKeyFormat) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *SlhDsaKeyFormat) GetParams() *SlhDsaParams {
	if x != nil {
		return x.Params
	}
	return nil
}

// key_type: type.googleapis.com/google.crypto.tink.SlhDsaPublicKey
type SlhDsaPublicKey struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Required.
	Version uint32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// Required.
	KeyValue []byte `protobuf:"bytes,2,opt,name=key_value,json=keyValue,proto3" json:"key_value,omitempty"` // Placeholder for ctype.
	// Required
	Params        *SlhDsaParams `protobuf:"bytes,3,opt,name=params,proto3" json:"params,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SlhDsaPublicKey) Reset() {
	*x = SlhDsaPublicKey{}
	mi := &file_slh_dsa_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SlhDsaPublicKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SlhDsaPublicKey) ProtoMessage() {}

func (x *SlhDsaPublicKey) ProtoReflect() protoreflect.Message {
	mi := &file_slh_dsa_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SlhDsaPublicKey.ProtoReflect.Descriptor instead.
func (*SlhDsaPublicKey) Descriptor() ([]byte, []int) {
	return file_slh_dsa_proto_rawDescGZIP(), []int{2}
}

func (x *SlhDsaPublicKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *SlhDsaPublicKey) GetKeyValue() []byte {
	if x != nil {
		return x.KeyValue
	}
	return nil
}

func (x *SlhDsaPublicKey) GetParams() *SlhDsaParams {
	if x != nil {
		return x.Params
	}
	return nil
}

// key_type: type.googleapis.com/google.crypto.tink.SlhDsaPrivateKey
type SlhDsaPrivateKey struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Required.
	Version uint32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// Required.
	KeyValue []byte `protobuf:"bytes,2,opt,name=key_value,json=keyValue,proto3" json:"key_value,omitempty"` // Placeholder for ctype.
	// Required. The corresponding public key.
	PublicKey     *SlhDsaPublicKey `protobuf:"bytes,3,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SlhDsaPrivateKey) Reset() {
	*x = SlhDsaPrivateKey{}
	mi := &file_slh_dsa_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SlhDsaPrivateKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SlhDsaPrivateKey) ProtoMessage() {}

func (x *SlhDsaPrivateKey) ProtoReflect() protoreflect.Message {
	mi := &file_slh_dsa_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SlhDsaPrivateKey.ProtoReflect.Descriptor instead.
func (*SlhDsaPrivateKey) Descriptor() ([]byte, []int) {
	return file_slh_dsa_proto_rawDescGZIP(), []int{3}
}

func (x *SlhDsaPrivateKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *SlhDsaPrivateKey) GetKeyValue() []byte {
	if x != nil {
		return x.KeyValue
	}
	return nil
}

func (x *SlhDsaPrivateKey) GetPublicKey() *SlhDsaPublicKey {
	if x != nil {
		return x.PublicKey
	}
	return nil
}

var File_slh_dsa_proto protoreflect.FileDescriptor

const file_slh_dsa_proto_rawDesc = "" +
	"\n" +
	"\rslh_dsa.proto\x12\x12google.crypto.tink\"\xae\x01\n" +
	"\fSlhDsaParams\x12\x19\n" +
	"\bkey_size\x18\x01 \x01(\x05R\akeySize\x12?\n" +
	"\thash_type\x18\x02 \x01(\x0e2\".google.crypto.tink.SlhDsaHashTypeR\bhashType\x12B\n" +
	"\bsig_type\x18\x03 \x01(\x0e2'.google.crypto.tink.SlhDsaSignatureTypeR\asigType\"e\n" +
	"\x0fSlhDsaKeyFormat\x12\x18\n" +
	"\aversion\x18\x01 \x01(\rR\aversion\x128\n" +
	"\x06params\x18\x02 \x01(\v2 .google.crypto.tink.SlhDsaParamsR\x06params\"\x82\x01\n" +
	"\x0fSlhDsaPublicKey\x12\x18\n" +
	"\aversion\x18\x01 \x01(\rR\aversion\x12\x1b\n" +
	"\tkey_value\x18\x02 \x01(\fR\bkeyValue\x128\n" +
	"\x06params\x18\x03 \x01(\v2 .google.crypto.tink.SlhDsaParamsR\x06params\"\x8d\x01\n" +
	"\x10SlhDsaPrivateKey\x12\x18\n" +
	"\aversion\x18\x01 \x01(\rR\aversion\x12\x1b\n" +
	"\tkey_value\x18\x02 \x01(\fR\bkeyValue\x12B\n" +
	"\n" +
	"public_key\x18\x03 \x01(\v2#.google.crypto.tink.SlhDsaPublicKeyR\tpublicKey*H\n" +
	"\x0eSlhDsaHashType\x12!\n" +
	"\x1dSLH_DSA_HASH_TYPE_UNSPECIFIED\x10\x00\x12\b\n" +
	"\x04SHA2\x10\x01\x12\t\n" +
	"\x05SHAKE\x10\x02*d\n" +
	"\x13SlhDsaSignatureType\x12&\n" +
	"\"SLH_DSA_SIGNATURE_TYPE_UNSPECIFIED\x10\x00\x12\x10\n" +
	"\fFAST_SIGNING\x10\x01\x12\x13\n" +
	"\x0fSMALL_SIGNATURE\x10\x02BW\n" +
	"\x1ccom.google.crypto.tink.protoP\x01Z5github.com/tink-crypto/tink-go/v2/proto/slh_dsa_protob\x06proto3"

var (
	file_slh_dsa_proto_rawDescOnce sync.Once
	file_slh_dsa_proto_rawDescData []byte
)

func file_slh_dsa_proto_rawDescGZIP() []byte {
	file_slh_dsa_proto_rawDescOnce.Do(func() {
		file_slh_dsa_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_slh_dsa_proto_rawDesc), len(file_slh_dsa_proto_rawDesc)))
	})
	return file_slh_dsa_proto_rawDescData
}

var file_slh_dsa_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_slh_dsa_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_slh_dsa_proto_goTypes = []any{
	(SlhDsaHashType)(0),      // 0: google.crypto.tink.SlhDsaHashType
	(SlhDsaSignatureType)(0), // 1: google.crypto.tink.SlhDsaSignatureType
	(*SlhDsaParams)(nil),     // 2: google.crypto.tink.SlhDsaParams
	(*SlhDsaKeyFormat)(nil),  // 3: google.crypto.tink.SlhDsaKeyFormat
	(*SlhDsaPublicKey)(nil),  // 4: google.crypto.tink.SlhDsaPublicKey
	(*SlhDsaPrivateKey)(nil), // 5: google.crypto.tink.SlhDsaPrivateKey
}
var file_slh_dsa_proto_depIdxs = []int32{
	0, // 0: google.crypto.tink.SlhDsaParams.hash_type:type_name -> google.crypto.tink.SlhDsaHashType
	1, // 1: google.crypto.tink.SlhDsaParams.sig_type:type_name -> google.crypto.tink.SlhDsaSignatureType
	2, // 2: google.crypto.tink.SlhDsaKeyFormat.params:type_name -> google.crypto.tink.SlhDsaParams
	2, // 3: google.crypto.tink.SlhDsaPublicKey.params:type_name -> google.crypto.tink.SlhDsaParams
	4, // 4: google.crypto.tink.SlhDsaPrivateKey.public_key:type_name -> google.crypto.tink.SlhDsaPublicKey
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_slh_dsa_proto_init() }
func file_slh_dsa_proto_init() {
	if File_slh_dsa_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_slh_dsa_proto_rawDesc), len(file_slh_dsa_proto_rawDesc)),
			NumEnums:      2,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_slh_dsa_proto_goTypes,
		DependencyIndexes: file_slh_dsa_proto_depIdxs,
		EnumInfos:         file_slh_dsa_proto_enumTypes,
		MessageInfos:      file_slh_dsa_proto_msgTypes,
	}.Build()
	File_slh_dsa_proto = out.File
	file_slh_dsa_proto_goTypes = nil
	file_slh_dsa_proto_depIdxs = nil
}
