#pragma once
/*
 *  $Id: color-axis.h 28517 2025-09-05 07:38:23Z yeti-dn $
 *  Copyright (C) 2003-2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_COLOR_AXIS_H__
#define __GWYUI_COLOR_AXIS_H__

#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk/gtk.h>
#include <libgwyddion/unit.h>
#include <libgwyddion/gradient.h>

G_BEGIN_DECLS

typedef enum {
    GWY_TICKS_STYLE_NONE,
    GWY_TICKS_STYLE_CENTER,
    GWY_TICKS_STYLE_AUTO,
    GWY_TICKS_STYLE_UNLABELED,
    GWY_TICKS_STYLE_UNLABELLED = GWY_TICKS_STYLE_UNLABELED
} GwyTicksStyle;

#define GWY_TYPE_COLOR_AXIS            (gwy_color_axis_get_type())
#define GWY_COLOR_AXIS(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_COLOR_AXIS, GwyColorAxis))
#define GWY_COLOR_AXIS_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_COLOR_AXIS, GwyColorAxisClass))
#define GWY_IS_COLOR_AXIS(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_COLOR_AXIS))
#define GWY_IS_COLOR_AXIS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_COLOR_AXIS))
#define GWY_COLOR_AXIS_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_COLOR_AXIS, GwyColorAxisClass))

typedef struct _GwyColorAxis             GwyColorAxis;
typedef struct _GwyColorAxisClass        GwyColorAxisClass;
typedef struct _GwyColorAxisPrivate      GwyColorAxisPrivate;

typedef void (*GwyColorAxisMapFunc)(GwyColorAxis *axis,
                                    const gdouble *z,
                                    gdouble *mapped,
                                    guint n,
                                    gpointer user_data);

struct _GwyColorAxis {
    GtkWidget widget;
    GwyColorAxisPrivate *priv;
};

struct _GwyColorAxisClass {
    GtkWidgetClass parent_class;

    void (*reserved1)(void);
    void (*reserved2)(void);
};


GType         gwy_color_axis_get_type          (void)                        G_GNUC_CONST;
GtkWidget*    gwy_color_axis_new               (GtkOrientation orientation);
GtkWidget*    gwy_color_axis_new_with_range    (GtkOrientation orientation,
                                                gdouble min,
                                                gdouble max);
void          gwy_color_axis_get_range         (GwyColorAxis *axis,
                                                gdouble *min,
                                                gdouble *max);
void          gwy_color_axis_set_range         (GwyColorAxis *axis,
                                                gdouble min,
                                                gdouble max);
GwyUnit*      gwy_color_axis_get_unit          (GwyColorAxis *axis);
void          gwy_color_axis_set_gradient      (GwyColorAxis *axis,
                                                GwyGradient *gradient);
GwyGradient*  gwy_color_axis_get_gradient      (GwyColorAxis *axis);
GwyTicksStyle gwy_color_axis_get_ticks_style   (GwyColorAxis *axis);
void          gwy_color_axis_set_ticks_style   (GwyColorAxis *axis,
                                                GwyTicksStyle ticks_style);
gboolean      gwy_color_axis_get_labels_visible(GwyColorAxis *axis);
void          gwy_color_axis_set_labels_visible(GwyColorAxis *axis,
                                                gboolean labels_visible);
void          gwy_color_axis_set_tick_map_func (GwyColorAxis *axis,
                                                GwyColorAxisMapFunc func,
                                                gpointer user_data);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
