/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

// SPDX-FileCopyrightText: 2020 - 2025 Kohei Yoshida
//
// SPDX-License-Identifier: MIT

#include <mdds/trie_map.hpp>
#include <iostream>

int main()
{
    //!code-start: type
    using trie_map_type = mdds::trie_map<std::string, int>;
    //!code-end: type

    //!code-start: inst
    // Cities in North Carolina and their populations in 2013.
    trie_map_type nc_cities;
    //!code-end: inst

    //!code-start: populate
    // Insert key-value pairs.
    nc_cities.insert("Charlotte",     792862);
    nc_cities.insert("Raleigh",       431746);
    nc_cities.insert("Greensboro",    279639);
    nc_cities.insert("Durham",        245475);
    nc_cities.insert("Winston-Salem", 236441);
    nc_cities.insert("Fayetteville",  204408);
    nc_cities.insert("Cary",          151088);
    nc_cities.insert("Wilmington",    112067);
    nc_cities.insert("High Point",    107741);
    nc_cities.insert("Greenville",    89130);
    nc_cities.insert("Asheville",     87236);
    nc_cities.insert("Concord",       83506);
    nc_cities.insert("Gastonia",      73209);
    nc_cities.insert("Jacksonville",  69079);
    nc_cities.insert("Chapel Hill",   59635);
    nc_cities.insert("Rocky Mount",   56954);
    nc_cities.insert("Burlington",    51510);
    nc_cities.insert("Huntersville",  50458);
    nc_cities.insert("Wilson",        49628);
    nc_cities.insert("Kannapolis",    44359);
    nc_cities.insert("Apex",          42214);
    nc_cities.insert("Hickory",       40361);
    nc_cities.insert("Goldsboro",     36306);
    //!code-end: populate

    //!code-start: search-cha
    std::cout << "Cities that start with 'Cha' and their populations:" << std::endl;
    auto results = nc_cities.prefix_search("Cha");
    for (const auto& kv : results)
    {
        std::cout << "  " << kv.first << ": " << kv.second << std::endl;
    }
    //!code-end: search-cha

    //!code-start: search-w
    std::cout << "Cities that start with 'W' and their populations:" << std::endl;
    results = nc_cities.prefix_search("W");
    for (const auto& kv : results)
    {
        std::cout << "  " << kv.first << ": " << kv.second << std::endl;
    }
    //!code-end: search-w

    //!code-start: pack
    auto packed = nc_cities.pack();
    //!code-end: pack

    //!code-start: search-c
    std::cout << "Cities that start with 'C' and their populations:" << std::endl;
    auto packed_results = packed.prefix_search("C");
    for (const auto& kv : packed_results)
    {
        std::cout << "  " << kv.first << ": " << kv.second << std::endl;
    }
    //!code-end: search-c

    //!code-start: find-one
    // Individual search.
    auto it = packed.find("Wilmington");
    std::cout << "Population of Wilmington: " << it->second << std::endl;
    //!code-end: find-one

    //!code-start: find-none
    // You get an end position iterator when the container doesn't have the
    // specified key.
    it = packed.find("Asheboro");

    std::cout << "Population of Asheboro: ";

    if (it == packed.end())
        std::cout << "not found";
    else
        std::cout << it->second;

    std::cout << std::endl;
    //!code-end: find-none

    return EXIT_SUCCESS;
}

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
