/*****************************************************************************
 *
 * This MobilityDB code is provided under The PostgreSQL License.
 * Copyright (c) 2016-2025, Université libre de Bruxelles and MobilityDB
 * contributors
 *
 * MobilityDB includes portions of PostGIS version 3 source code released
 * under the GNU General Public License (GPLv2 or later).
 * Copyright (c) 2001-2025, PostGIS contributors
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without a written
 * agreement is hereby granted, provided that the above copyright notice and
 * this paragraph and the following two paragraphs appear in all copies.
 *
 * IN NO EVENT SHALL UNIVERSITE LIBRE DE BRUXELLES BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING
 * LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION,
 * EVEN IF UNIVERSITE LIBRE DE BRUXELLES HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * UNIVERSITE LIBRE DE BRUXELLES SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON
 * AN "AS IS" BASIS, AND UNIVERSITE LIBRE DE BRUXELLES HAS NO OBLIGATIONS TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 *****************************************************************************/

/**
 * @defgroup meos_npoint_base Functions for static network points
 * @ingroup meos_npoint
 * @brief Functions for static network points
 *
 * @defgroup meos_npoint_set Functions for network point sets
 * @ingroup meos_npoint
 * @brief Functions for network point sets
 *
 * @defgroup meos_npoint_inout Input and output functions
 * @ingroup meos_npoint
 * @brief Input and output functions for temporal network points
 *
 * @defgroup meos_npoint_conversion Conversion functions
 * @ingroup meos_npoint
 * @brief Conversion functions for temporal network points
 *
 * @defgroup meos_npoint_accessor Accessor functions
 * @ingroup meos_npoint
 * @brief Accessor functions for temporal network points
 *
 * @defgroup meos_npoint_restrict Restriction functions
 * @ingroup meos_npoint
 * @brief Restriction functions for temporal network points
 *
 * @defgroup meos_npoint_dist Distance functions
 * @ingroup meos_npoint
 * @brief Distance functions for temporal network points
 *
 * @defgroup meos_npoint_agg Aggregate functions
 * @ingroup meos_npoint
 * @brief Aggregate functions for temporal network points
 *
 * @defgroup meos_npoint_comp Comparison functions
 * @ingroup meos_npoint
 * @brief Comparison functions for temporal network points
 *
 *   @defgroup meos_npoint_comp_ever Ever and always comparison functions
 *   @ingroup meos_npoint_comp
 *   @brief Ever and always comparison functions for temporal network points
 *
 *   @defgroup meos_npoint_comp_temp Temporal comparison functions
 *   @ingroup meos_npoint_comp
 *   @brief Temporal comparison functions for temporal network points
 */

/*****************************************************************************/

/**
 * @defgroup meos_npoint_base_inout Input and output functions
 * @ingroup meos_npoint_base
 * @brief Input and output functions for static network points
 *
 * @defgroup meos_npoint_base_constructor Constructor functions
 * @ingroup meos_npoint_base
 * @brief Constructor functions for static network points
 *
 * @defgroup meos_npoint_base_conversion Conversion functions
 * @ingroup meos_npoint_base
 * @brief Conversion functions for static network points
 *
 * @defgroup meos_npoint_base_accessor Accessor functions
 * @ingroup meos_npoint_base
 * @brief Accessor functions for static network points
 *
 * @defgroup meos_npoint_base_route Route functions
 * @ingroup meos_npoint_base
 * @brief Route functions for static network points
 *
 * @defgroup meos_npoint_base_transf Transformation functions
 * @ingroup meos_npoint_base
 * @brief Transformation functions for static network points
 *
 * @defgroup meos_npoint_base_srid Spatial reference system functions
 * @ingroup meos_npoint_base
 * @brief Spatial reference system functions for static network points
 *
 * @defgroup meos_npoint_base_comp Comparison functions
 * @ingroup meos_npoint_base
 * @brief Comparison functions for static network points
 */

/*****************************************************************************/

/**
 * @defgroup meos_npoint_set_inout Input and output functions
 * @ingroup meos_npoint_set
 * @brief Input and output functions for network point sets
 *
 * @defgroup meos_npoint_set_constructor Constructor functions
 * @ingroup meos_npoint_set
 * @brief Constructor functions for network point sets
 *
 * @defgroup meos_npoint_set_conversion Conversion functions
 * @ingroup meos_npoint_set
 * @brief Conversion functions for network point sets
 *
 * @defgroup meos_npoint_set_accessor Accessor functions
 * @ingroup meos_npoint_set
 * @brief Accessor functions for network point sets
 *
 * @defgroup meos_npoint_set_setops Set operations
 * @ingroup meos_npoint_set
 * @brief Set operations for network point sets
 */

/*****************************************************************************/
