# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class FhirResourceVersionPolicy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Controls how resources are versioned on the FHIR service."""

    NO_VERSION = "no-version"
    VERSIONED = "versioned"
    VERSIONED_UPDATE = "versioned-update"


class FhirServiceKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of the service."""

    FHIR_STU3 = "fhir-Stu3"
    FHIR_R4 = "fhir-R4"


class IotIdentityResolutionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of IoT identity resolution to use with the destination."""

    CREATE = "Create"
    LOOKUP = "Lookup"


class Kind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of the service."""

    FHIR = "fhir"
    FHIR_STU3 = "fhir-Stu3"
    FHIR_R4 = "fhir-R4"


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of identity being specified, currently SystemAssigned and None are allowed."""

    SYSTEM_ASSIGNED = "SystemAssigned"
    NONE = "None"


class OperationResultStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the operation being performed."""

    CANCELED = "Canceled"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    REQUESTED = "Requested"
    RUNNING = "Running"


class PrivateEndpointConnectionProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current provisioning state."""

    SUCCEEDED = "Succeeded"
    CREATING = "Creating"
    DELETING = "Deleting"
    FAILED = "Failed"


class PrivateEndpointServiceConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The private endpoint connection status."""

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state."""

    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    CREATING = "Creating"
    ACCEPTED = "Accepted"
    VERIFYING = "Verifying"
    UPDATING = "Updating"
    FAILED = "Failed"
    CANCELED = "Canceled"
    DEPROVISIONED = "Deprovisioned"
    MOVING = "Moving"
    SUSPENDED = "Suspended"
    WARNED = "Warned"
    SYSTEM_MAINTENANCE = "SystemMaintenance"


class PublicNetworkAccess(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Control permission for data plane traffic coming from public networks while private endpoint is
    enabled.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class ServiceEventState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the current status of event support for the resource."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"
    UPDATING = "Updating"


class ServiceManagedIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of identity being specified, currently SystemAssigned and None are allowed."""

    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"


class ServiceNameUnavailabilityReason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The reason for unavailability."""

    INVALID = "Invalid"
    ALREADY_EXISTS = "AlreadyExists"


class SmartDataActions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Data Actions that can be enabled for a Smart Identity Provider Application."""

    READ = "Read"
