# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class Code(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The operation status code."""

    SUCCEEDED = "Succeeded"
    """Extension was created/updated successfully."""
    FAILED = "Failed"
    """Extension was not created/updated successfully. See operation status message for more details."""


class Enforce(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """If set to "False", it allows the descendants of this scope to override the pricing
    configuration set on this scope (allows setting inherited="False"). If set to "True", it
    prevents overrides and forces this pricing configuration on all the descendants of this scope.
    This field is only available for subscription-level pricing.
    """

    FALSE = "False"
    """Allows the descendants of this scope to override the pricing configuration set on this scope
    (allows setting inherited="False")"""
    TRUE = "True"
    """Prevents overrides and forces the current scope's pricing configuration to all descendants"""


class Inherited(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ "inherited" = "True" indicates that the current scope inherits its pricing configuration from
    its parent. The ID of the parent scope that provides the inherited configuration is displayed
    in the "inheritedFrom" field. On the other hand, "inherited" = "False" indicates that the
    current scope has its own pricing configuration explicitly set, and does not inherit from its
    parent. This field is read only and available only for resource-level pricing.
    """

    TRUE = "True"
    """Indicates that the current scope is inheriting its pricing configuration from its parent"""
    FALSE = "False"
    """Indicates that the current scope sets its own pricing configuration and does not inherit it
    from its parent"""


class IsEnabled(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether the extension is enabled."""

    TRUE = "True"
    """Indicates the extension is enabled"""
    FALSE = "False"
    """Indicates the extension is disabled"""


class PricingTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether the Defender plan is enabled on the selected scope. Microsoft Defender for
    Cloud is provided in two pricing tiers: free and standard. The standard tier offers advanced
    security capabilities, while the free tier offers basic security features.
    """

    FREE = "Free"
    """Get free Microsoft Defender for Cloud experience with basic security features"""
    STANDARD = "Standard"
    """Get the standard Microsoft Defender for Cloud experience with advanced security features"""


class ResourcesCoverageStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This field is available for subscription-level only, and reflects the coverage status of the
    resources under the subscription. Please note: The "pricingTier" field reflects the plan status
    of the subscription. However, since the plan status can also be defined at the resource level,
    there might be misalignment between the subscription's plan status and the resource status.
    This field helps indicate the coverage status of the resources.
    """

    FULLY_COVERED = "FullyCovered"
    """This value indicates that all resources associated with the subscription have the Defender plan
    enabled."""
    PARTIALLY_COVERED = "PartiallyCovered"
    """This value indicates that some resources under the subscription have the Defender plan enabled,
    while others have it disabled. There is a mixed coverage status among resources."""
    NOT_COVERED = "NotCovered"
    """This value indicates that the Defender plan is disabled for all resources under the
    subscription. None of the resources are protected by the Defender plan."""
