% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ser_permutation.R
\name{ser_permutation}
\alias{ser_permutation}
\alias{print.ser_permutation}
\alias{summary.ser_permutation}
\alias{c.ser_permutation}
\alias{[.ser_permutation}
\title{Class ser_permutation -- A Collection of Permutation Vectors for Seriation}
\usage{
ser_permutation(x, ...)

\method{print}{ser_permutation}(x, ...)

\method{summary}{ser_permutation}(object, ...)

\method{c}{ser_permutation}(..., recursive = FALSE)

\method{[}{ser_permutation}(object, i, ...)
}
\arguments{
\item{x, object}{an object of class \code{ser_permutation_vector} or
any object which can be converted into
a object of class \code{ser_permutation} (e.g. an integer
vector).}

\item{...}{vectors for further dimensions.}

\item{recursive}{ignored.}

\item{i}{index of the dimension(s) to extract.}
}
\value{
An object of class \code{ser_permutation}.
}
\description{
The class \code{ser_permutation} is a collection of permutation vectors
(see class \link{ser_permutation_vector}), one for each dimension (mode)
of the data to be permuted.
}
\examples{
o <- ser_permutation(1:5, 10:1)
o

## length (number of dimensions)
length(o)

## get permutation vector for 2nd dimension
get_order(o, 2)

## reverse dimensions
o[2:1]

## combine
o <- c(o, ser_permutation(1:15))
o

## get an individual permutation
o[[2]]

## reverse the order of a permutation
o[[2]] <- rev(o[[2]])
get_order(o,2)
}
\seealso{
Other permutation: 
\code{\link{get_order}()},
\code{\link{permutation_vector2matrix}()},
\code{\link{permute}()},
\code{\link{ser_dist}()},
\code{\link{ser_permutation_vector}()}
}
\author{
Michael Hahsler
}
\concept{permutation}
\keyword{classes}
