// This file is part of ICU4X. For terms of use, please see the file
// called LICENSE at the top level of the ICU4X source tree
// (online at: https://github.com/unicode-org/icu4x/blob/main/LICENSE ).

//! Data obtained from ICU4C:
//! <https://github.com/unicode-org/icu/blob/1bf6bf774dbc8c6c2051963a81100ea1114b497f/icu4c/source/i18n/islamcal.cpp#L264>

use super::PackedHijriYearData;

pub const STARTING_YEAR: i32 = 1300;

#[rustfmt::skip]
#[allow(clippy::unwrap_used)] // const
pub const DATA: &[PackedHijriYearData] = {
    use calendrical_calculations::gregorian::fixed_from_gregorian as gregorian;
    let l = true; // long
    let s = false; // short
    &[
        PackedHijriYearData::try_new(1300, [l, s, l, s, l, s, l, s, l, s, l, s], gregorian(1882, 11, 12)).unwrap(),
        PackedHijriYearData::try_new(1301, [l, l, s, l, s, l, s, l, s, l, s, s], gregorian(1883, 11, 1)).unwrap(),
        PackedHijriYearData::try_new(1302, [l, l, l, s, l, l, s, s, l, s, s, l], gregorian(1884, 10, 20)).unwrap(),
        PackedHijriYearData::try_new(1303, [s, l, l, s, l, l, s, l, s, l, s, s], gregorian(1885, 10, 10)).unwrap(),
        PackedHijriYearData::try_new(1304, [s, l, l, s, l, l, l, s, l, s, l, s], gregorian(1886, 9, 29)).unwrap(),
        PackedHijriYearData::try_new(1305, [s, s, l, l, s, l, l, s, l, l, s, s], gregorian(1887, 9, 19)).unwrap(),
        PackedHijriYearData::try_new(1306, [l, s, l, s, l, s, l, s, l, l, s, l], gregorian(1888, 9, 7)).unwrap(),
        PackedHijriYearData::try_new(1307, [s, l, s, l, s, l, s, l, s, l, s, l], gregorian(1889, 8, 28)).unwrap(),
        PackedHijriYearData::try_new(1308, [s, l, l, s, l, s, l, s, l, s, s, l], gregorian(1890, 8, 17)).unwrap(),
        PackedHijriYearData::try_new(1309, [s, l, l, l, l, s, s, l, s, s, l, s], gregorian(1891, 8, 6)).unwrap(),
        PackedHijriYearData::try_new(1310, [l, s, l, l, l, s, l, s, l, s, s, l], gregorian(1892, 7, 25)).unwrap(),
        PackedHijriYearData::try_new(1311, [s, l, s, l, l, l, s, l, s, l, s, s], gregorian(1893, 7, 15)).unwrap(),
        PackedHijriYearData::try_new(1312, [l, s, l, s, l, l, s, l, l, s, l, s], gregorian(1894, 7, 4)).unwrap(),
        PackedHijriYearData::try_new(1313, [s, l, s, l, s, l, s, l, l, l, s, s], gregorian(1895, 6, 24)).unwrap(),
        PackedHijriYearData::try_new(1314, [l, l, s, l, s, s, l, s, l, l, s, l], gregorian(1896, 6, 12)).unwrap(),
        PackedHijriYearData::try_new(1315, [s, l, l, s, l, s, s, l, s, l, s, l], gregorian(1897, 6, 2)).unwrap(),
        PackedHijriYearData::try_new(1316, [s, l, l, l, s, l, s, s, l, s, l, s], gregorian(1898, 5, 22)).unwrap(),
        PackedHijriYearData::try_new(1317, [l, s, l, l, s, l, s, l, s, l, s, s], gregorian(1899, 5, 11)).unwrap(),
        PackedHijriYearData::try_new(1318, [l, s, l, l, s, l, l, s, l, s, l, s], gregorian(1900, 4, 30)).unwrap(),
        PackedHijriYearData::try_new(1319, [s, l, s, l, l, s, l, s, l, l, s, l], gregorian(1901, 4, 20)).unwrap(),
        PackedHijriYearData::try_new(1320, [s, l, s, s, l, s, l, s, l, l, l, s], gregorian(1902, 4, 10)).unwrap(),
        PackedHijriYearData::try_new(1321, [l, s, l, s, s, l, s, s, l, l, l, l], gregorian(1903, 3, 30)).unwrap(),
        PackedHijriYearData::try_new(1322, [s, l, s, l, s, s, s, l, s, l, l, l], gregorian(1904, 3, 19)).unwrap(),
        PackedHijriYearData::try_new(1323, [s, l, l, s, l, s, s, s, l, s, l, l], gregorian(1905, 3, 8)).unwrap(),
        PackedHijriYearData::try_new(1324, [s, l, l, s, l, s, l, s, s, l, s, l], gregorian(1906, 2, 25)).unwrap(),
        PackedHijriYearData::try_new(1325, [l, s, l, s, l, l, s, l, s, l, s, l], gregorian(1907, 2, 14)).unwrap(),
        PackedHijriYearData::try_new(1326, [s, s, l, s, l, l, s, l, s, l, l, s], gregorian(1908, 2, 4)).unwrap(),
        PackedHijriYearData::try_new(1327, [l, s, s, l, s, l, s, l, l, s, l, l], gregorian(1909, 1, 23)).unwrap(),
        PackedHijriYearData::try_new(1328, [s, l, s, s, l, s, s, l, l, l, s, l], gregorian(1910, 1, 13)).unwrap(),
        PackedHijriYearData::try_new(1329, [l, s, l, s, s, l, s, s, l, l, s, l], gregorian(1911, 1, 2)).unwrap(),
        PackedHijriYearData::try_new(1330, [l, l, s, l, s, s, l, s, s, l, l, s], gregorian(1911, 12, 22)).unwrap(),
        PackedHijriYearData::try_new(1331, [l, l, s, l, l, s, s, l, s, l, s, l], gregorian(1912, 12, 10)).unwrap(),
        PackedHijriYearData::try_new(1332, [s, l, s, l, l, s, l, s, l, l, s, s], gregorian(1913, 11, 30)).unwrap(),
        PackedHijriYearData::try_new(1333, [l, s, s, l, l, s, l, l, s, l, l, s], gregorian(1914, 11, 19)).unwrap(),
        PackedHijriYearData::try_new(1334, [s, s, l, s, l, s, l, l, l, s, l, s], gregorian(1915, 11, 9)).unwrap(),
        PackedHijriYearData::try_new(1335, [l, s, l, s, s, l, s, l, l, s, l, l], gregorian(1916, 10, 28)).unwrap(),
        PackedHijriYearData::try_new(1336, [s, l, s, l, s, s, l, s, l, s, l, l], gregorian(1917, 10, 18)).unwrap(),
        PackedHijriYearData::try_new(1337, [l, s, l, s, l, s, s, l, s, l, s, l], gregorian(1918, 10, 7)).unwrap(),
        PackedHijriYearData::try_new(1338, [s, l, l, s, l, l, s, s, l, s, l, s], gregorian(1919, 9, 26)).unwrap(),
        PackedHijriYearData::try_new(1339, [l, s, l, s, l, l, l, s, l, s, s, l], gregorian(1920, 9, 14)).unwrap(),
        PackedHijriYearData::try_new(1340, [s, s, l, s, l, l, l, l, s, l, s, s], gregorian(1921, 9, 4)).unwrap(),
        PackedHijriYearData::try_new(1341, [l, s, s, l, s, l, l, l, s, l, l, s], gregorian(1922, 8, 24)).unwrap(),
        PackedHijriYearData::try_new(1342, [s, s, l, s, l, s, l, l, s, l, l, s], gregorian(1923, 8, 14)).unwrap(),
        PackedHijriYearData::try_new(1343, [l, s, s, l, s, l, s, l, s, l, l, s], gregorian(1924, 8, 2)).unwrap(),
        PackedHijriYearData::try_new(1344, [l, s, l, s, l, l, s, s, l, s, l, s], gregorian(1925, 7, 22)).unwrap(),
        PackedHijriYearData::try_new(1345, [l, s, l, l, l, s, l, s, s, l, s, s], gregorian(1926, 7, 11)).unwrap(),
        PackedHijriYearData::try_new(1346, [l, s, l, l, l, l, s, l, s, s, l, s], gregorian(1927, 6, 30)).unwrap(),
        PackedHijriYearData::try_new(1347, [s, l, s, l, l, l, s, l, l, s, s, l], gregorian(1928, 6, 19)).unwrap(),
        PackedHijriYearData::try_new(1348, [s, s, l, s, l, l, s, l, l, l, s, s], gregorian(1929, 6, 9)).unwrap(),
        PackedHijriYearData::try_new(1349, [l, s, s, l, s, l, l, s, l, l, s, l], gregorian(1930, 5, 29)).unwrap(),
        PackedHijriYearData::try_new(1350, [s, l, s, l, s, l, s, s, l, l, s, l], gregorian(1931, 5, 19)).unwrap(),
        PackedHijriYearData::try_new(1351, [l, s, l, s, l, s, l, s, s, l, s, l], gregorian(1932, 5, 7)).unwrap(),
        PackedHijriYearData::try_new(1352, [l, s, l, l, s, l, s, l, s, s, l, s], gregorian(1933, 4, 26)).unwrap(),
        PackedHijriYearData::try_new(1353, [l, s, l, l, l, s, l, s, s, l, s, l], gregorian(1934, 4, 15)).unwrap(),
        PackedHijriYearData::try_new(1354, [s, l, s, l, l, s, l, l, s, l, s, s], gregorian(1935, 4, 5)).unwrap(),
        PackedHijriYearData::try_new(1355, [l, s, s, l, l, s, l, l, s, l, l, s], gregorian(1936, 3, 24)).unwrap(),
        PackedHijriYearData::try_new(1356, [s, l, s, l, s, l, s, l, s, l, l, l], gregorian(1937, 3, 14)).unwrap(),
        PackedHijriYearData::try_new(1357, [s, s, l, s, l, s, s, l, s, l, l, l], gregorian(1938, 3, 4)).unwrap(),
        PackedHijriYearData::try_new(1358, [s, l, s, l, s, l, s, s, l, s, l, l], gregorian(1939, 2, 21)).unwrap(),
        PackedHijriYearData::try_new(1359, [s, l, l, s, l, s, l, s, s, s, l, l], gregorian(1940, 2, 10)).unwrap(),
        PackedHijriYearData::try_new(1360, [s, l, l, l, s, l, s, l, s, s, l, s], gregorian(1941, 1, 29)).unwrap(),
        PackedHijriYearData::try_new(1361, [l, s, l, l, s, l, l, s, s, l, s, l], gregorian(1942, 1, 18)).unwrap(),
        PackedHijriYearData::try_new(1362, [s, l, s, l, s, l, l, s, l, s, l, s], gregorian(1943, 1, 8)).unwrap(),
        PackedHijriYearData::try_new(1363, [l, s, l, s, l, s, l, s, l, s, l, l], gregorian(1943, 12, 28)).unwrap(),
        PackedHijriYearData::try_new(1364, [s, l, s, l, s, s, l, s, l, s, l, l], gregorian(1944, 12, 17)).unwrap(),
        PackedHijriYearData::try_new(1365, [l, l, s, s, l, s, s, l, s, l, s, l], gregorian(1945, 12, 6)).unwrap(),
        PackedHijriYearData::try_new(1366, [l, l, s, l, s, l, s, s, l, s, l, s], gregorian(1946, 11, 25)).unwrap(),
        PackedHijriYearData::try_new(1367, [l, l, s, l, l, s, l, s, s, l, s, l], gregorian(1947, 11, 14)).unwrap(),
        PackedHijriYearData::try_new(1368, [s, l, s, l, l, l, s, s, l, s, l, s], gregorian(1948, 11, 3)).unwrap(),
        PackedHijriYearData::try_new(1369, [l, s, l, s, l, l, s, l, s, l, l, s], gregorian(1949, 10, 23)).unwrap(),
        PackedHijriYearData::try_new(1370, [l, s, s, l, s, l, s, l, s, l, l, l], gregorian(1950, 10, 13)).unwrap(),
        PackedHijriYearData::try_new(1371, [s, l, s, s, l, s, l, s, l, s, l, l], gregorian(1951, 10, 3)).unwrap(),
        PackedHijriYearData::try_new(1372, [l, s, s, l, s, l, s, s, l, s, l, l], gregorian(1952, 9, 21)).unwrap(),
        PackedHijriYearData::try_new(1373, [l, s, l, s, l, s, l, s, s, l, s, l], gregorian(1953, 9, 10)).unwrap(),
        PackedHijriYearData::try_new(1374, [l, s, l, l, s, l, s, l, s, s, l, s], gregorian(1954, 8, 30)).unwrap(),
        PackedHijriYearData::try_new(1375, [l, s, l, l, s, l, l, s, l, s, l, s], gregorian(1955, 8, 19)).unwrap(),
        PackedHijriYearData::try_new(1376, [s, l, s, l, s, l, l, l, s, l, s, l], gregorian(1956, 8, 8)).unwrap(),
        PackedHijriYearData::try_new(1377, [s, s, l, s, s, l, l, l, s, l, l, s], gregorian(1957, 7, 29)).unwrap(),
        PackedHijriYearData::try_new(1378, [l, s, s, s, l, s, l, l, s, l, l, l], gregorian(1958, 7, 18)).unwrap(),
        PackedHijriYearData::try_new(1379, [s, l, s, s, s, l, s, l, l, s, l, l], gregorian(1959, 7, 8)).unwrap(),
        PackedHijriYearData::try_new(1380, [s, l, s, l, s, l, s, l, s, l, s, l], gregorian(1960, 6, 26)).unwrap(),
        PackedHijriYearData::try_new(1381, [s, l, s, l, l, s, l, s, l, s, s, l], gregorian(1961, 6, 15)).unwrap(),
        PackedHijriYearData::try_new(1382, [s, l, s, l, l, s, l, l, s, l, s, s], gregorian(1962, 6, 4)).unwrap(),
        PackedHijriYearData::try_new(1383, [l, s, s, l, l, l, s, l, l, s, l, s], gregorian(1963, 5, 24)).unwrap(),
        PackedHijriYearData::try_new(1384, [s, l, s, s, l, l, s, l, l, l, s, l], gregorian(1964, 5, 13)).unwrap(),
        PackedHijriYearData::try_new(1385, [s, s, l, s, s, l, l, s, l, l, l, s], gregorian(1965, 5, 3)).unwrap(),
        PackedHijriYearData::try_new(1386, [l, s, s, l, s, s, l, l, s, l, l, s], gregorian(1966, 4, 22)).unwrap(),
        PackedHijriYearData::try_new(1387, [l, s, l, s, l, s, l, s, l, s, l, s], gregorian(1967, 4, 11)).unwrap(),
        PackedHijriYearData::try_new(1388, [l, l, s, l, s, l, s, l, s, l, s, s], gregorian(1968, 3, 30)).unwrap(),
        PackedHijriYearData::try_new(1389, [l, l, s, l, l, s, l, l, s, s, l, s], gregorian(1969, 3, 19)).unwrap(),
        PackedHijriYearData::try_new(1390, [s, l, s, l, l, l, s, l, s, l, s, l], gregorian(1970, 3, 9)).unwrap(),
        PackedHijriYearData::try_new(1391, [s, s, l, s, l, l, s, l, l, s, l, s], gregorian(1971, 2, 27)).unwrap(),
        PackedHijriYearData::try_new(1392, [l, s, s, l, s, l, s, l, l, s, l, l], gregorian(1972, 2, 16)).unwrap(),
        PackedHijriYearData::try_new(1393, [s, l, s, s, l, s, l, s, l, s, l, l], gregorian(1973, 2, 5)).unwrap(),
        PackedHijriYearData::try_new(1394, [l, s, l, s, s, l, s, l, s, l, s, l], gregorian(1974, 1, 25)).unwrap(),
        PackedHijriYearData::try_new(1395, [l, s, l, l, s, l, s, s, l, s, s, l], gregorian(1975, 1, 14)).unwrap(),
        PackedHijriYearData::try_new(1396, [l, s, l, l, s, l, l, s, s, l, s, s], gregorian(1976, 1, 3)).unwrap(),
        PackedHijriYearData::try_new(1397, [l, s, l, l, s, l, l, l, s, s, s, l], gregorian(1976, 12, 22)).unwrap(),
        PackedHijriYearData::try_new(1398, [s, l, s, l, l, s, l, l, s, l, s, s], gregorian(1977, 12, 12)).unwrap(),
        PackedHijriYearData::try_new(1399, [l, s, l, s, l, s, l, l, s, l, s, l], gregorian(1978, 12, 1)).unwrap(),
        PackedHijriYearData::try_new(1400, [l, s, l, s, s, l, s, l, s, l, s, l], gregorian(1979, 11, 21)).unwrap(),
        PackedHijriYearData::try_new(1401, [l, l, s, l, s, s, l, s, s, l, s, l], gregorian(1980, 11, 9)).unwrap(),
        PackedHijriYearData::try_new(1402, [l, l, l, s, l, s, s, l, s, s, l, s], gregorian(1981, 10, 29)).unwrap(),
        PackedHijriYearData::try_new(1403, [l, l, l, s, l, l, s, s, l, s, s, l], gregorian(1982, 10, 18)).unwrap(),
        PackedHijriYearData::try_new(1404, [s, l, l, s, l, l, s, l, s, l, s, s], gregorian(1983, 10, 8)).unwrap(),
        PackedHijriYearData::try_new(1405, [l, s, l, s, l, l, l, s, l, s, s, l], gregorian(1984, 9, 26)).unwrap(),
        PackedHijriYearData::try_new(1406, [l, s, s, l, s, l, l, s, l, s, l, l], gregorian(1985, 9, 16)).unwrap(),
        PackedHijriYearData::try_new(1407, [s, l, s, s, l, s, l, s, l, s, l, l], gregorian(1986, 9, 6)).unwrap(),
        PackedHijriYearData::try_new(1408, [l, s, l, s, l, s, s, l, s, s, l, l], gregorian(1987, 8, 26)).unwrap(),
        PackedHijriYearData::try_new(1409, [l, l, s, l, s, l, s, s, l, s, s, l], gregorian(1988, 8, 14)).unwrap(),
        PackedHijriYearData::try_new(1410, [l, l, s, l, l, s, l, s, s, l, s, s], gregorian(1989, 8, 3)).unwrap(),
        PackedHijriYearData::try_new(1411, [l, l, s, l, l, s, l, l, s, s, l, s], gregorian(1990, 7, 23)).unwrap(),
        PackedHijriYearData::try_new(1412, [l, s, l, s, l, s, l, l, l, s, s, l], gregorian(1991, 7, 13)).unwrap(),
        PackedHijriYearData::try_new(1413, [s, l, s, s, l, s, l, l, l, s, l, s], gregorian(1992, 7, 2)).unwrap(),
        PackedHijriYearData::try_new(1414, [l, s, l, s, s, l, s, l, l, s, l, l], gregorian(1993, 6, 21)).unwrap(),
        PackedHijriYearData::try_new(1415, [s, l, s, l, s, s, l, s, l, s, l, l], gregorian(1994, 6, 11)).unwrap(),
        PackedHijriYearData::try_new(1416, [l, s, l, s, l, s, s, l, s, l, s, l], gregorian(1995, 5, 31)).unwrap(),
        PackedHijriYearData::try_new(1417, [l, s, l, l, s, s, l, s, l, s, l, s], gregorian(1996, 5, 19)).unwrap(),
        PackedHijriYearData::try_new(1418, [l, s, l, l, s, l, s, l, s, l, s, l], gregorian(1997, 5, 8)).unwrap(),
        PackedHijriYearData::try_new(1419, [s, l, s, l, s, l, s, l, l, l, s, s], gregorian(1998, 4, 28)).unwrap(),
        PackedHijriYearData::try_new(1420, [s, l, s, s, l, s, l, l, l, l, s, l], gregorian(1999, 4, 17)).unwrap(),
        PackedHijriYearData::try_new(1421, [s, s, l, s, s, s, l, l, l, l, s, l], gregorian(2000, 4, 6)).unwrap(),
        PackedHijriYearData::try_new(1422, [l, s, s, l, s, s, s, l, l, l, s, l], gregorian(2001, 3, 26)).unwrap(),
        PackedHijriYearData::try_new(1423, [l, s, l, s, l, s, s, l, s, l, s, l], gregorian(2002, 3, 15)).unwrap(),
        PackedHijriYearData::try_new(1424, [l, s, l, l, s, l, s, s, l, s, l, s], gregorian(2003, 3, 4)).unwrap(),
        PackedHijriYearData::try_new(1425, [l, s, l, l, s, l, s, l, l, s, l, s], gregorian(2004, 2, 21)).unwrap(),
        PackedHijriYearData::try_new(1426, [s, l, s, l, s, l, l, s, l, l, s, l], gregorian(2005, 2, 10)).unwrap(),
        PackedHijriYearData::try_new(1427, [s, s, l, s, l, s, l, l, s, l, l, s], gregorian(2006, 1, 31)).unwrap(),
        PackedHijriYearData::try_new(1428, [l, s, s, l, s, s, l, l, l, s, l, l], gregorian(2007, 1, 20)).unwrap(),
        PackedHijriYearData::try_new(1429, [s, l, s, s, l, s, s, l, l, s, l, l], gregorian(2008, 1, 10)).unwrap(),
        PackedHijriYearData::try_new(1430, [s, l, l, s, s, l, s, l, s, l, s, l], gregorian(2008, 12, 29)).unwrap(),
        PackedHijriYearData::try_new(1431, [s, l, l, s, l, s, l, s, l, s, s, l], gregorian(2009, 12, 18)).unwrap(),
        PackedHijriYearData::try_new(1432, [s, l, l, l, s, l, s, l, s, l, s, s], gregorian(2010, 12, 7)).unwrap(),
        PackedHijriYearData::try_new(1433, [l, s, l, l, s, l, l, s, l, s, l, s], gregorian(2011, 11, 26)).unwrap(),
        PackedHijriYearData::try_new(1434, [s, l, s, l, s, l, l, s, l, l, s, s], gregorian(2012, 11, 15)).unwrap(),
        PackedHijriYearData::try_new(1435, [l, s, l, s, l, s, l, s, l, l, s, l], gregorian(2013, 11, 4)).unwrap(),
        PackedHijriYearData::try_new(1436, [s, l, s, l, s, l, s, l, s, l, s, l], gregorian(2014, 10, 25)).unwrap(),
        PackedHijriYearData::try_new(1437, [l, s, l, l, s, s, l, s, l, s, s, l], gregorian(2015, 10, 14)).unwrap(),
        PackedHijriYearData::try_new(1438, [l, s, l, l, l, s, s, l, s, s, l, s], gregorian(2016, 10, 2)).unwrap(),
        PackedHijriYearData::try_new(1439, [l, s, l, l, l, s, l, s, l, s, s, l], gregorian(2017, 9, 21)).unwrap(),
        PackedHijriYearData::try_new(1440, [s, l, s, l, l, l, s, l, s, l, s, s], gregorian(2018, 9, 11)).unwrap(),
        PackedHijriYearData::try_new(1441, [l, s, l, s, l, l, s, l, l, s, l, s], gregorian(2019, 8, 31)).unwrap(),
        PackedHijriYearData::try_new(1442, [s, l, s, l, s, l, s, l, l, s, l, s], gregorian(2020, 8, 20)).unwrap(),
        PackedHijriYearData::try_new(1443, [l, s, l, s, l, s, l, s, l, s, l, l], gregorian(2021, 8, 9)).unwrap(),
        PackedHijriYearData::try_new(1444, [s, l, s, l, l, s, s, l, s, l, s, l], gregorian(2022, 7, 30)).unwrap(),
        PackedHijriYearData::try_new(1445, [s, l, l, l, s, l, s, s, l, s, s, l], gregorian(2023, 7, 19)).unwrap(),
        PackedHijriYearData::try_new(1446, [s, l, l, l, s, l, l, s, s, l, s, s], gregorian(2024, 7, 7)).unwrap(),
        PackedHijriYearData::try_new(1447, [l, s, l, l, l, s, l, s, l, s, l, s], gregorian(2025, 6, 26)).unwrap(),
        PackedHijriYearData::try_new(1448, [s, l, s, l, l, s, l, l, s, l, s, l], gregorian(2026, 6, 16)).unwrap(),
        PackedHijriYearData::try_new(1449, [s, s, l, s, l, s, l, l, s, l, l, s], gregorian(2027, 6, 6)).unwrap(),
        PackedHijriYearData::try_new(1450, [l, s, l, s, s, l, s, l, s, l, l, s], gregorian(2028, 5, 25)).unwrap(),
        PackedHijriYearData::try_new(1451, [l, l, l, s, s, l, s, s, l, l, s, l], gregorian(2029, 5, 14)).unwrap(),
        PackedHijriYearData::try_new(1452, [l, s, l, l, s, s, l, s, s, l, s, l], gregorian(2030, 5, 4)).unwrap(),
        PackedHijriYearData::try_new(1453, [l, s, l, l, s, l, s, l, s, s, l, s], gregorian(2031, 4, 23)).unwrap(),
        PackedHijriYearData::try_new(1454, [l, s, l, l, s, l, l, s, l, s, l, s], gregorian(2032, 4, 11)).unwrap(),
        PackedHijriYearData::try_new(1455, [s, l, s, l, l, s, l, s, l, l, s, l], gregorian(2033, 4, 1)).unwrap(),
        PackedHijriYearData::try_new(1456, [s, s, l, s, l, s, l, s, l, l, l, s], gregorian(2034, 3, 22)).unwrap(),
        PackedHijriYearData::try_new(1457, [l, s, s, l, s, s, l, s, l, l, l, l], gregorian(2035, 3, 11)).unwrap(),
        PackedHijriYearData::try_new(1458, [s, l, s, s, l, s, s, l, s, l, l, l], gregorian(2036, 2, 29)).unwrap(),
        PackedHijriYearData::try_new(1459, [s, l, l, s, s, l, s, s, l, s, l, l], gregorian(2037, 2, 17)).unwrap(),
        PackedHijriYearData::try_new(1460, [s, l, l, s, l, s, l, s, s, l, s, l], gregorian(2038, 2, 6)).unwrap(),
        PackedHijriYearData::try_new(1461, [s, l, l, s, l, s, l, s, l, l, s, s], gregorian(2039, 1, 26)).unwrap(),
        PackedHijriYearData::try_new(1462, [l, s, l, s, l, l, s, l, s, l, l, s], gregorian(2040, 1, 15)).unwrap(),
        PackedHijriYearData::try_new(1463, [s, l, s, l, s, l, s, l, l, l, s, l], gregorian(2041, 1, 4)).unwrap(),
        PackedHijriYearData::try_new(1464, [s, l, s, s, l, s, s, l, l, l, s, l], gregorian(2041, 12, 25)).unwrap(),
        PackedHijriYearData::try_new(1465, [l, s, l, s, s, l, s, s, l, l, s, l], gregorian(2042, 12, 14)).unwrap(),
        PackedHijriYearData::try_new(1466, [l, l, s, l, s, s, s, l, s, l, l, s], gregorian(2043, 12, 3)).unwrap(),
        PackedHijriYearData::try_new(1467, [l, l, s, l, l, s, s, l, s, l, s, l], gregorian(2044, 11, 21)).unwrap(),
        PackedHijriYearData::try_new(1468, [s, l, s, l, l, s, l, s, l, s, l, s], gregorian(2045, 11, 11)).unwrap(),
        PackedHijriYearData::try_new(1469, [s, l, s, l, l, s, l, l, s, l, s, l], gregorian(2046, 10, 31)).unwrap(),
        PackedHijriYearData::try_new(1470, [s, s, l, s, l, l, s, l, l, s, l, s], gregorian(2047, 10, 21)).unwrap(),
        PackedHijriYearData::try_new(1471, [l, s, s, l, s, l, s, l, l, s, l, l], gregorian(2048, 10, 9)).unwrap(),
        PackedHijriYearData::try_new(1472, [s, l, s, s, l, s, l, s, l, l, s, l], gregorian(2049, 9, 29)).unwrap(),
        PackedHijriYearData::try_new(1473, [s, l, s, l, l, s, s, l, s, l, s, l], gregorian(2050, 9, 18)).unwrap(),
        PackedHijriYearData::try_new(1474, [s, l, l, s, l, l, s, s, l, s, l, s], gregorian(2051, 9, 7)).unwrap(),
        PackedHijriYearData::try_new(1475, [s, l, l, s, l, l, l, s, s, l, s, s], gregorian(2052, 8, 26)).unwrap(),
        PackedHijriYearData::try_new(1476, [l, s, l, s, l, l, l, s, l, s, l, s], gregorian(2053, 8, 15)).unwrap(),
        PackedHijriYearData::try_new(1477, [s, l, s, s, l, l, l, l, s, l, s, l], gregorian(2054, 8, 5)).unwrap(),
        PackedHijriYearData::try_new(1478, [s, s, l, s, l, s, l, l, s, l, l, s], gregorian(2055, 7, 26)).unwrap(),
        PackedHijriYearData::try_new(1479, [l, s, s, l, s, l, s, l, s, l, l, s], gregorian(2056, 7, 14)).unwrap(),
        PackedHijriYearData::try_new(1480, [l, s, l, s, l, s, l, s, l, s, l, s], gregorian(2057, 7, 3)).unwrap(),
        PackedHijriYearData::try_new(1481, [l, s, l, l, s, l, s, l, s, l, s, s], gregorian(2058, 6, 22)).unwrap(),
        PackedHijriYearData::try_new(1482, [l, s, l, l, l, l, s, l, s, s, l, s], gregorian(2059, 6, 11)).unwrap(),
        PackedHijriYearData::try_new(1483, [s, l, s, l, l, l, s, l, l, s, s, l], gregorian(2060, 5, 31)).unwrap(),
        PackedHijriYearData::try_new(1484, [s, s, l, s, l, l, l, s, l, s, l, s], gregorian(2061, 5, 21)).unwrap(),
        PackedHijriYearData::try_new(1485, [l, s, s, l, s, l, l, s, l, l, s, l], gregorian(2062, 5, 10)).unwrap(),
        PackedHijriYearData::try_new(1486, [s, l, s, s, l, s, l, s, l, l, s, l], gregorian(2063, 4, 30)).unwrap(),
        PackedHijriYearData::try_new(1487, [l, s, l, s, l, s, s, l, s, l, s, l], gregorian(2064, 4, 18)).unwrap(),
        PackedHijriYearData::try_new(1488, [l, s, l, l, s, l, s, s, l, s, l, s], gregorian(2065, 4, 7)).unwrap(),
        PackedHijriYearData::try_new(1489, [l, s, l, l, l, s, l, s, s, l, s, l], gregorian(2066, 3, 27)).unwrap(),
        PackedHijriYearData::try_new(1490, [s, l, s, l, l, s, l, l, s, s, l, s], gregorian(2067, 3, 17)).unwrap(),
        PackedHijriYearData::try_new(1491, [l, s, s, l, l, s, l, l, s, l, s, l], gregorian(2068, 3, 5)).unwrap(),
        PackedHijriYearData::try_new(1492, [s, l, s, s, l, l, s, l, s, l, l, s], gregorian(2069, 2, 23)).unwrap(),
        PackedHijriYearData::try_new(1493, [l, s, l, s, l, s, s, l, s, l, l, l], gregorian(2070, 2, 12)).unwrap(),
        PackedHijriYearData::try_new(1494, [s, l, s, l, s, l, s, s, s, l, l, l], gregorian(2071, 2, 2)).unwrap(),
        PackedHijriYearData::try_new(1495, [s, l, l, s, l, s, s, l, s, s, l, l], gregorian(2072, 1, 22)).unwrap(),
        PackedHijriYearData::try_new(1496, [s, l, l, l, s, l, s, s, l, s, s, l], gregorian(2073, 1, 10)).unwrap(),
        PackedHijriYearData::try_new(1497, [l, s, l, l, s, l, s, l, s, l, s, l], gregorian(2073, 12, 30)).unwrap(),
        PackedHijriYearData::try_new(1498, [s, l, s, l, s, l, l, s, l, s, l, s], gregorian(2074, 12, 20)).unwrap(),
        PackedHijriYearData::try_new(1499, [l, s, l, s, s, l, l, s, l, s, l, l], gregorian(2075, 12, 9)).unwrap(),
        PackedHijriYearData::try_new(1500, [s, l, s, l, s, s, l, s, l, s, l, l], gregorian(2076, 11, 28)).unwrap(),
        PackedHijriYearData::try_new(1501, [l, s, l, s, l, s, s, s, l, s, l, l], gregorian(2077, 11, 17)).unwrap(),
        PackedHijriYearData::try_new(1502, [l, l, s, l, s, l, s, s, s, l, l, s], gregorian(2078, 11, 6)).unwrap(),
        PackedHijriYearData::try_new(1503, [l, l, s, l, l, s, l, s, s, s, l, l], gregorian(2079, 10, 26)).unwrap(),
        PackedHijriYearData::try_new(1504, [s, l, s, l, l, l, s, s, l, s, l, s], gregorian(2080, 10, 15)).unwrap(),
        PackedHijriYearData::try_new(1505, [l, s, l, s, l, l, s, l, s, l, l, s], gregorian(2081, 10, 4)).unwrap(),
        PackedHijriYearData::try_new(1506, [s, l, s, s, l, l, s, l, l, s, l, l], gregorian(2082, 9, 24)).unwrap(),
        PackedHijriYearData::try_new(1507, [s, s, l, s, s, l, l, s, l, s, l, l], gregorian(2083, 9, 14)).unwrap(),
        PackedHijriYearData::try_new(1508, [l, s, s, l, s, l, s, s, l, s, l, l], gregorian(2084, 9, 2)).unwrap(),
        PackedHijriYearData::try_new(1509, [l, s, l, s, l, s, l, s, s, l, s, l], gregorian(2085, 8, 22)).unwrap(),
        PackedHijriYearData::try_new(1510, [l, s, l, l, s, l, s, l, s, s, l, s], gregorian(2086, 8, 11)).unwrap(),
        PackedHijriYearData::try_new(1511, [l, s, l, l, s, l, l, s, l, s, s, l], gregorian(2087, 7, 31)).unwrap(),
        PackedHijriYearData::try_new(1512, [s, l, s, l, s, l, l, l, s, l, s, l], gregorian(2088, 7, 20)).unwrap(),
        PackedHijriYearData::try_new(1513, [s, s, s, l, s, l, l, l, s, l, l, s], gregorian(2089, 7, 10)).unwrap(),
        PackedHijriYearData::try_new(1514, [l, s, s, s, l, s, l, l, s, l, l, l], gregorian(2090, 6, 29)).unwrap(),
        PackedHijriYearData::try_new(1515, [s, s, l, s, s, l, s, l, l, s, l, l], gregorian(2091, 6, 19)).unwrap(),
        PackedHijriYearData::try_new(1516, [s, l, s, l, s, s, l, s, l, s, l, l], gregorian(2092, 6, 7)).unwrap(),
        PackedHijriYearData::try_new(1517, [s, l, s, l, s, l, l, s, s, l, s, l], gregorian(2093, 5, 27)).unwrap(),
        PackedHijriYearData::try_new(1518, [s, l, s, l, l, s, l, l, s, l, s, s], gregorian(2094, 5, 16)).unwrap(),
        PackedHijriYearData::try_new(1519, [l, s, s, l, l, l, s, l, l, s, l, s], gregorian(2095, 5, 5)).unwrap(),
        PackedHijriYearData::try_new(1520, [s, l, s, s, l, l, l, s, l, l, s, l], gregorian(2096, 4, 24)).unwrap(),
        PackedHijriYearData::try_new(1521, [s, s, s, l, s, l, l, s, l, l, s, l], gregorian(2097, 4, 14)).unwrap(),
        PackedHijriYearData::try_new(1522, [l, s, s, s, l, s, l, l, s, l, l, s], gregorian(2098, 4, 3)).unwrap(),
        PackedHijriYearData::try_new(1523, [l, s, l, s, l, s, l, s, s, l, l, s], gregorian(2099, 3, 23)).unwrap(),
        PackedHijriYearData::try_new(1524, [l, l, s, l, s, l, s, l, s, s, l, s], gregorian(2100, 3, 12)).unwrap(),
        PackedHijriYearData::try_new(1525, [l, l, s, l, l, s, l, s, l, s, s, l], gregorian(2101, 3, 1)).unwrap(),
        PackedHijriYearData::try_new(1526, [s, l, s, l, l, l, s, l, s, l, s, s], gregorian(2102, 2, 19)).unwrap(),
        PackedHijriYearData::try_new(1527, [l, s, l, s, l, l, s, l, l, s, l, s], gregorian(2103, 2, 8)).unwrap(),
        PackedHijriYearData::try_new(1528, [l, s, s, l, s, l, s, l, l, s, l, l], gregorian(2104, 1, 29)).unwrap(),
        PackedHijriYearData::try_new(1529, [s, l, s, s, l, s, l, s, l, s, l, l], gregorian(2105, 1, 18)).unwrap(),
        PackedHijriYearData::try_new(1530, [s, l, l, s, s, l, s, l, s, s, l, l], gregorian(2106, 1, 7)).unwrap(),
        PackedHijriYearData::try_new(1531, [s, l, l, l, s, s, l, s, l, s, s, l], gregorian(2106, 12, 27)).unwrap(),
        PackedHijriYearData::try_new(1532, [s, l, l, l, s, l, l, s, s, s, l, s], gregorian(2107, 12, 16)).unwrap(),
        PackedHijriYearData::try_new(1533, [l, s, l, l, l, s, l, s, l, s, s, l], gregorian(2108, 12, 4)).unwrap(),
        PackedHijriYearData::try_new(1534, [s, l, s, l, l, s, l, l, s, s, l, s], gregorian(2109, 11, 24)).unwrap(),
        PackedHijriYearData::try_new(1535, [l, s, l, s, l, s, l, l, s, l, s, l], gregorian(2110, 11, 13)).unwrap(),
        PackedHijriYearData::try_new(1536, [s, l, s, l, s, l, s, l, s, l, s, l], gregorian(2111, 11, 3)).unwrap(),
        PackedHijriYearData::try_new(1537, [l, s, l, l, s, s, l, s, s, l, s, l], gregorian(2112, 10, 22)).unwrap(),
        PackedHijriYearData::try_new(1538, [l, l, s, l, l, s, s, l, s, s, l, s], gregorian(2113, 10, 11)).unwrap(),
        PackedHijriYearData::try_new(1539, [l, l, l, s, l, l, s, s, l, s, s, l], gregorian(2114, 9, 30)).unwrap(),
        PackedHijriYearData::try_new(1540, [s, l, l, s, l, l, s, l, s, s, l, s], gregorian(2115, 9, 20)).unwrap(),
        PackedHijriYearData::try_new(1541, [l, s, l, s, l, l, l, s, l, s, s, l], gregorian(2116, 9, 8)).unwrap(),
        PackedHijriYearData::try_new(1542, [s, l, s, l, s, l, l, s, l, s, l, l], gregorian(2117, 8, 29)).unwrap(),
        PackedHijriYearData::try_new(1543, [s, l, s, s, l, s, l, s, l, s, l, l], gregorian(2118, 8, 19)).unwrap(),
        PackedHijriYearData::try_new(1544, [l, s, l, s, s, l, s, l, s, l, s, l], gregorian(2119, 8, 8)).unwrap(),
        PackedHijriYearData::try_new(1545, [l, l, s, l, s, s, l, s, l, s, s, l], gregorian(2120, 7, 27)).unwrap(),
        PackedHijriYearData::try_new(1546, [l, l, s, l, s, l, s, l, s, l, s, s], gregorian(2121, 7, 16)).unwrap(),
        PackedHijriYearData::try_new(1547, [l, l, s, l, l, s, l, s, l, s, l, s], gregorian(2122, 7, 5)).unwrap(),
        PackedHijriYearData::try_new(1548, [l, s, s, l, l, s, l, l, s, l, s, l], gregorian(2123, 6, 25)).unwrap(),
        PackedHijriYearData::try_new(1549, [s, l, s, s, l, s, l, l, l, s, l, s], gregorian(2124, 6, 14)).unwrap(),
        PackedHijriYearData::try_new(1550, [l, s, l, s, s, s, l, l, l, s, l, l], gregorian(2125, 6, 3)).unwrap(),
        PackedHijriYearData::try_new(1551, [s, l, s, s, l, s, s, l, l, s, l, l], gregorian(2126, 5, 24)).unwrap(),
        PackedHijriYearData::try_new(1552, [l, s, l, s, s, l, s, s, l, l, s, l], gregorian(2127, 5, 13)).unwrap(),
        PackedHijriYearData::try_new(1553, [l, s, l, s, l, s, l, s, l, s, l, s], gregorian(2128, 5, 1)).unwrap(),
        PackedHijriYearData::try_new(1554, [l, s, l, s, l, l, s, l, s, l, s, l], gregorian(2129, 4, 20)).unwrap(),
        PackedHijriYearData::try_new(1555, [s, s, l, s, l, l, s, l, l, s, l, s], gregorian(2130, 4, 10)).unwrap(),
        PackedHijriYearData::try_new(1556, [l, s, s, l, s, l, s, l, l, l, s, l], gregorian(2131, 3, 30)).unwrap(),
        PackedHijriYearData::try_new(1557, [s, l, s, s, s, l, s, l, l, l, l, s], gregorian(2132, 3, 19)).unwrap(),
        PackedHijriYearData::try_new(1558, [l, s, l, s, s, s, l, s, l, l, l, s], gregorian(2133, 3, 8)).unwrap(),
        PackedHijriYearData::try_new(1559, [l, l, s, s, l, s, s, l, l, s, l, s], gregorian(2134, 2, 25)).unwrap(),
        PackedHijriYearData::try_new(1560, [l, l, s, l, s, l, s, l, s, l, s, l], gregorian(2135, 2, 14)).unwrap(),
        PackedHijriYearData::try_new(1561, [s, l, l, s, l, s, l, l, s, s, l, s], gregorian(2136, 2, 4)).unwrap(),
        PackedHijriYearData::try_new(1562, [s, l, l, s, l, s, l, l, l, s, s, l], gregorian(2137, 1, 23)).unwrap(),
        PackedHijriYearData::try_new(1563, [s, l, s, s, l, s, l, l, l, s, l, s], gregorian(2138, 1, 13)).unwrap(),
        PackedHijriYearData::try_new(1564, [l, s, l, s, s, l, s, l, l, l, s, l], gregorian(2139, 1, 2)).unwrap(),
        PackedHijriYearData::try_new(1565, [s, l, s, l, s, s, l, s, l, l, s, l], gregorian(2139, 12, 23)).unwrap(),
        PackedHijriYearData::try_new(1566, [l, s, l, s, l, s, s, l, s, l, s, l], gregorian(2140, 12, 11)).unwrap(),
        PackedHijriYearData::try_new(1567, [l, s, l, l, s, l, s, l, s, s, l, s], gregorian(2141, 11, 30)).unwrap(),
        PackedHijriYearData::try_new(1568, [l, s, l, l, l, s, l, s, l, s, s, s], gregorian(2142, 11, 19)).unwrap(),
        PackedHijriYearData::try_new(1569, [l, s, l, l, l, s, l, l, s, l, s, s], gregorian(2143, 11, 8)).unwrap(),
        PackedHijriYearData::try_new(1570, [s, l, s, l, l, s, l, l, l, s, s, l], gregorian(2144, 10, 28)).unwrap(),
        PackedHijriYearData::try_new(1571, [s, s, l, s, l, l, s, l, l, s, l, s], gregorian(2145, 10, 18)).unwrap(),
        PackedHijriYearData::try_new(1572, [l, s, s, l, s, l, s, l, l, s, l, s], gregorian(2146, 10, 7)).unwrap(),
        PackedHijriYearData::try_new(1573, [l, s, l, l, s, l, s, s, l, s, l, s], gregorian(2147, 9, 26)).unwrap(),
        PackedHijriYearData::try_new(1574, [l, l, s, l, l, s, l, s, s, l, s, s], gregorian(2148, 9, 14)).unwrap(),
        PackedHijriYearData::try_new(1575, [l, l, l, s, l, l, s, l, s, s, s, l], gregorian(2149, 9, 3)).unwrap(),
        PackedHijriYearData::try_new(1576, [s, l, l, s, l, l, l, s, l, s, s, s], gregorian(2150, 8, 24)).unwrap(),
        PackedHijriYearData::try_new(1577, [l, s, l, l, s, l, l, s, l, s, l, s], gregorian(2151, 8, 13)).unwrap(),
        PackedHijriYearData::try_new(1578, [s, l, s, l, s, l, l, s, l, l, s, l], gregorian(2152, 8, 2)).unwrap(),
        PackedHijriYearData::try_new(1579, [s, l, s, l, s, s, l, l, s, l, s, l], gregorian(2153, 7, 23)).unwrap(),
        PackedHijriYearData::try_new(1580, [s, l, l, s, l, s, s, l, s, l, s, l], gregorian(2154, 7, 12)).unwrap(),
        PackedHijriYearData::try_new(1581, [l, l, s, l, s, l, s, s, l, s, l, s], gregorian(2155, 7, 1)).unwrap(),
        PackedHijriYearData::try_new(1582, [l, l, s, l, l, s, l, s, l, s, s, s], gregorian(2156, 6, 19)).unwrap(),
        PackedHijriYearData::try_new(1583, [l, l, s, l, l, l, s, l, s, l, s, s], gregorian(2157, 6, 8)).unwrap(),
        PackedHijriYearData::try_new(1584, [s, l, l, s, l, l, s, l, l, s, l, s], gregorian(2158, 5, 29)).unwrap(),
        PackedHijriYearData::try_new(1585, [s, l, s, l, s, l, s, l, l, s, l, l], gregorian(2159, 5, 19)).unwrap(),
        PackedHijriYearData::try_new(1586, [s, s, l, s, l, s, s, l, l, l, s, l], gregorian(2160, 5, 8)).unwrap(),
        PackedHijriYearData::try_new(1587, [s, l, l, s, s, s, l, s, l, s, l, l], gregorian(2161, 4, 27)).unwrap(),
        PackedHijriYearData::try_new(1588, [l, s, l, l, s, s, s, l, s, l, s, l], gregorian(2162, 4, 16)).unwrap(),
        PackedHijriYearData::try_new(1589, [l, s, l, l, s, l, s, s, l, s, l, s], gregorian(2163, 4, 5)).unwrap(),
        PackedHijriYearData::try_new(1590, [l, s, l, l, l, s, s, l, s, l, s, l], gregorian(2164, 3, 24)).unwrap(),
        PackedHijriYearData::try_new(1591, [s, l, s, l, l, s, l, s, l, s, l, s], gregorian(2165, 3, 14)).unwrap(),
        PackedHijriYearData::try_new(1592, [l, s, l, s, l, s, l, s, l, l, l, s], gregorian(2166, 3, 3)).unwrap(),
        PackedHijriYearData::try_new(1593, [l, s, s, l, s, s, l, s, l, l, l, s], gregorian(2167, 2, 21)).unwrap(),
        PackedHijriYearData::try_new(1594, [l, l, s, s, l, s, s, s, l, l, l, l], gregorian(2168, 2, 10)).unwrap(),
        PackedHijriYearData::try_new(1595, [s, l, s, l, s, s, l, s, s, l, l, l], gregorian(2169, 1, 30)).unwrap(),
        PackedHijriYearData::try_new(1596, [s, l, l, s, l, s, s, l, s, l, s, l], gregorian(2170, 1, 19)).unwrap(),
        PackedHijriYearData::try_new(1597, [s, l, l, s, l, s, l, s, l, s, l, s], gregorian(2171, 1, 8)).unwrap(),
        PackedHijriYearData::try_new(1598, [l, s, l, s, l, l, s, l, s, l, l, s], gregorian(2171, 12, 28)).unwrap(),
        PackedHijriYearData::try_new(1599, [s, l, s, l, s, l, s, l, l, l, s, l], gregorian(2172, 12, 17)).unwrap(),
        PackedHijriYearData::try_new(1600, [s, s, l, s, l, s, s, l, l, l, s, l], gregorian(2173, 12, 7)).unwrap(),
    ]
};

#[test]
fn test_icu4c_agreement() {
    use calendrical_calculations::islamic::ISLAMIC_EPOCH_FRIDAY;

    // From https://github.com/unicode-org/icu/blob/1bf6bf774dbc8c6c2051963a81100ea1114b497f/icu4c/source/i18n/islamcal.cpp#L87
    const ICU4C_ENCODED_MONTH_LENGTHS: [u16; 1601 - 1300] = [
        0x0AAA, 0x0D54, 0x0EC9, 0x06D4, 0x06EA, 0x036C, 0x0AAD, 0x0555, 0x06A9, 0x0792, 0x0BA9,
        0x05D4, 0x0ADA, 0x055C, 0x0D2D, 0x0695, 0x074A, 0x0B54, 0x0B6A, 0x05AD, 0x04AE, 0x0A4F,
        0x0517, 0x068B, 0x06A5, 0x0AD5, 0x02D6, 0x095B, 0x049D, 0x0A4D, 0x0D26, 0x0D95, 0x05AC,
        0x09B6, 0x02BA, 0x0A5B, 0x052B, 0x0A95, 0x06CA, 0x0AE9, 0x02F4, 0x0976, 0x02B6, 0x0956,
        0x0ACA, 0x0BA4, 0x0BD2, 0x05D9, 0x02DC, 0x096D, 0x054D, 0x0AA5, 0x0B52, 0x0BA5, 0x05B4,
        0x09B6, 0x0557, 0x0297, 0x054B, 0x06A3, 0x0752, 0x0B65, 0x056A, 0x0AAB, 0x052B, 0x0C95,
        0x0D4A, 0x0DA5, 0x05CA, 0x0AD6, 0x0957, 0x04AB, 0x094B, 0x0AA5, 0x0B52, 0x0B6A, 0x0575,
        0x0276, 0x08B7, 0x045B, 0x0555, 0x05A9, 0x05B4, 0x09DA, 0x04DD, 0x026E, 0x0936, 0x0AAA,
        0x0D54, 0x0DB2, 0x05D5, 0x02DA, 0x095B, 0x04AB, 0x0A55, 0x0B49, 0x0B64, 0x0B71, 0x05B4,
        0x0AB5, 0x0A55, 0x0D25, 0x0E92, 0x0EC9, 0x06D4, 0x0AE9, 0x096B, 0x04AB, 0x0A93, 0x0D49,
        0x0DA4, 0x0DB2, 0x0AB9, 0x04BA, 0x0A5B, 0x052B, 0x0A95, 0x0B2A, 0x0B55, 0x055C, 0x04BD,
        0x023D, 0x091D, 0x0A95, 0x0B4A, 0x0B5A, 0x056D, 0x02B6, 0x093B, 0x049B, 0x0655, 0x06A9,
        0x0754, 0x0B6A, 0x056C, 0x0AAD, 0x0555, 0x0B29, 0x0B92, 0x0BA9, 0x05D4, 0x0ADA, 0x055A,
        0x0AAB, 0x0595, 0x0749, 0x0764, 0x0BAA, 0x05B5, 0x02B6, 0x0A56, 0x0E4D, 0x0B25, 0x0B52,
        0x0B6A, 0x05AD, 0x02AE, 0x092F, 0x0497, 0x064B, 0x06A5, 0x06AC, 0x0AD6, 0x055D, 0x049D,
        0x0A4D, 0x0D16, 0x0D95, 0x05AA, 0x05B5, 0x02DA, 0x095B, 0x04AD, 0x0595, 0x06CA, 0x06E4,
        0x0AEA, 0x04F5, 0x02B6, 0x0956, 0x0AAA, 0x0B54, 0x0BD2, 0x05D9, 0x02EA, 0x096D, 0x04AD,
        0x0A95, 0x0B4A, 0x0BA5, 0x05B2, 0x09B5, 0x04D6, 0x0A97, 0x0547, 0x0693, 0x0749, 0x0B55,
        0x056A, 0x0A6B, 0x052B, 0x0A8B, 0x0D46, 0x0DA3, 0x05CA, 0x0AD6, 0x04DB, 0x026B, 0x094B,
        0x0AA5, 0x0B52, 0x0B69, 0x0575, 0x0176, 0x08B7, 0x025B, 0x052B, 0x0565, 0x05B4, 0x09DA,
        0x04ED, 0x016D, 0x08B6, 0x0AA6, 0x0D52, 0x0DA9, 0x05D4, 0x0ADA, 0x095B, 0x04AB, 0x0653,
        0x0729, 0x0762, 0x0BA9, 0x05B2, 0x0AB5, 0x0555, 0x0B25, 0x0D92, 0x0EC9, 0x06D2, 0x0AE9,
        0x056B, 0x04AB, 0x0A55, 0x0D29, 0x0D54, 0x0DAA, 0x09B5, 0x04BA, 0x0A3B, 0x049B, 0x0A4D,
        0x0AAA, 0x0AD5, 0x02DA, 0x095D, 0x045E, 0x0A2E, 0x0C9A, 0x0D55, 0x06B2, 0x06B9, 0x04BA,
        0x0A5D, 0x052D, 0x0A95, 0x0B52, 0x0BA8, 0x0BB4, 0x05B9, 0x02DA, 0x095A, 0x0B4A, 0x0DA4,
        0x0ED1, 0x06E8, 0x0B6A, 0x056D, 0x0535, 0x0695, 0x0D4A, 0x0DA8, 0x0DD4, 0x06DA, 0x055B,
        0x029D, 0x062B, 0x0B15, 0x0B4A, 0x0B95, 0x05AA, 0x0AAE, 0x092E, 0x0C8F, 0x0527, 0x0695,
        0x06AA, 0x0AD6, 0x055D, 0x029D,
    ];

    // From https://github.com/unicode-org/icu/blob/1bf6bf774dbc8c6c2051963a81100ea1114b497f/icu4c/source/i18n/islamcal.cpp#L264
    const ICU4C_YEAR_START_ESTIMATE_FIX: [i64; 1601 - 1300] = [
        0, 0, -1, 0, -1, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, -1, 0, 1, 0, 1, 1, 0, 0, 0, 0, 1,
        0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, -1, -1, 0, 0, 0, 1, 0, 0, -1, 0, 0, 0, 1,
        1, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 1, 1, 0, 0, -1, 0, 1, 0, 1, 1, 0, 0, -1, 0, 1, 0,
        0, 0, -1, 0, 1, 0, 1, 0, 0, 0, -1, 0, 0, 0, 0, -1, -1, 0, -1, 0, 1, 0, 0, 0, -1, 0, 0, 0,
        1, 0, 0, 0, 0, 0, 1, 0, 0, -1, -1, 0, 0, 0, 1, 0, 0, -1, -1, 0, -1, 0, 0, -1, -1, 0, -1, 0,
        -1, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, -1, 0, 1, 0, 1, 1, 0, 0, -1, 0, 1, 0, 0, 0, 0, 0, 1, 0,
        1, 0, 0, 0, -1, 0, 1, 0, 0, -1, -1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1,
        0, 0, -1, 0, 0, 0, 1, 1, 0, 0, -1, 0, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, -1, 0, 0, 0, 1,
        0, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0, -1, 0, 1, 0, 0, 0, -1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0,
        0, -1, 0, 0, 0, 0, 1, 0, 0, 0, -1, 0, 0, 0, 0, -1, -1, 0, -1, 0, 1, 0, 0, -1, -1, 0, 0, 1,
        1, 0, 0, -1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1,
    ];

    let icu4c = ICU4C_ENCODED_MONTH_LENGTHS
        .into_iter()
        .zip(ICU4C_YEAR_START_ESTIMATE_FIX)
        .enumerate()
        .map(
            |(years_since_1300, (encoded_months_lengths, year_start_estimate_fix))| {
                // https://github.com/unicode-org/icu/blob/1bf6bf774dbc8c6c2051963a81100ea1114b497f/icu4c/source/i18n/islamcal.cpp#L858
                let month_lengths =
                    core::array::from_fn(|i| (1 << (11 - i)) & encoded_months_lengths != 0);
                // From https://github.com/unicode-org/icu/blob/1bf6bf774dbc8c6c2051963a81100ea1114b497f/icu4c/source/i18n/islamcal.cpp#L813
                let year_start = ((354.36720 * years_since_1300 as f64) + 460322.05 + 0.5) as i64
                    + year_start_estimate_fix;
                (
                    1300 + years_since_1300 as i32,
                    PackedHijriYearData::try_new(
                        1300 + years_since_1300 as i32,
                        month_lengths,
                        ISLAMIC_EPOCH_FRIDAY + year_start,
                    )
                    .unwrap(),
                )
            },
        )
        .collect::<Vec<_>>();

    let icu4x = (1300..=1600).zip(DATA.iter().copied()).collect::<Vec<_>>();

    assert_eq!(icu4x, icu4c);
}
