---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, structures, 
              racine carrée, racine cubique, symbole racine, radicande, 
              racine n-ième
---

# Comment écrire une racine (carrée ou autre) ?

Le symbole de la racine carrée d'un élément (appelé 
le [radicande](wpfr:Racine_carrée)) s'obtient avec la commande 
`\sqrt{⟨radicande⟩}`. De façon plus générale, la commande 
`\sqrt[⟨n⟩]{⟨radicande⟩}` permet d'afficher la racine `⟨n⟩`{sup}`e` 
du `⟨radicande⟩`. 

Voici quelques exemples d'utilisation dans lesquels vous pourrez observer 
que la taille du symbole racine s'ajuste automatiquement à celle du radicande.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\[
  \sqrt[3]{\sqrt{\sqrt[\gamma]{x+y}}} + \sqrt{\frac{x+y}{x-y}} + \sqrt{x-y} 
\]
\end{document}
```