/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

public class ZipUtil {
    public static boolean isZipFile(String string) {
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream(), 8192);
            boolean bl = ZipUtil.isZipFile(bufferedInputStream);
            bufferedInputStream.close();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isZipFile(InputStream inputStream) throws Exception {
        byte[] byArray = new byte[4];
        inputStream.mark(5);
        int n = inputStream.read(byArray, 0, 4);
        inputStream.reset();
        return n == 4 && byArray[0] == 80 && byArray[1] == 75 && byArray[2] == 3 && byArray[3] == 4;
    }

    public static boolean isZipFile(byte[] byArray) throws Exception {
        return byArray.length > 4 && byArray[0] == 80 && byArray[1] == 75 && byArray[2] == 3 && byArray[3] == 4;
    }

    public static ZipInputStream getStream(InputStream inputStream) {
        return inputStream instanceof ZipInputStream ? (ZipInputStream)inputStream : (inputStream instanceof BufferedInputStream ? new ZipInputStream(inputStream) : new ZipInputStream(new BufferedInputStream(inputStream)));
    }

    public static void getAllData(InputStream inputStream, String[] stringArray, String string, String string2, Hashtable hashtable) {
        ZipInputStream zipInputStream = ZipUtil.getStream(inputStream);
        StringBuffer stringBuffer = new StringBuffer();
        string2 = "|" + string2 + "|";
        String string3 = TextFormat.join(stringArray, '/', 1);
        String string4 = null;
        if (string3 != null && (string4 = string3.substring(0, string3.indexOf("/") + 1)).length() == 0) {
            string4 = null;
        }
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string5;
                String string6 = zipEntry.getName();
                if (string3 != null && string4 != null && !string6.equals(string3) && !string6.startsWith(string4)) continue;
                stringBuffer.append(string6).append('\n');
                String string7 = "|" + string6.substring(string6.lastIndexOf("/") + 1) + "|";
                boolean bl = string2.indexOf(string7) >= 0;
                byte[] byArray = ZipUtil.getZipEntryAsBytes(zipInputStream);
                if (bl) {
                    string5 = ZipUtil.getBinaryStringForBytes(byArray);
                    string6 = string6 + ":asBinaryString";
                } else {
                    string5 = new String(byArray);
                }
                string5 = "BEGIN Directory Entry " + string6 + "\n" + string5 + "\nEND Directory Entry " + string6 + "\n";
                hashtable.put(string + "|" + string6, string5);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        hashtable.put("#Directory_Listing", stringBuffer.toString());
    }

    public static String getBinaryStringForBytes(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(Integer.toHexString(byArray[i] & 0xFF)).append(' ');
        }
        return stringBuffer.toString();
    }

    public static Object getZipFileContents(InputStream inputStream, String[] stringArray, int n, boolean bl) {
        if (stringArray == null || n >= stringArray.length) {
            return ZipUtil.getZipDirectoryAsStringAndClose(inputStream);
        }
        String string = stringArray[n];
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            ZipEntry zipEntry;
            boolean bl2 = string.equals(".");
            if (bl2 || string.lastIndexOf("/") == string.length() - 1) {
                String string2;
                ZipEntry zipEntry2;
                StringBuffer stringBuffer = new StringBuffer();
                while ((zipEntry2 = zipInputStream.getNextEntry()) != null) {
                    string2 = zipEntry2.getName();
                    if (!bl2 && !string2.startsWith(string)) continue;
                    stringBuffer.append(string2).append('\n');
                }
                string2 = stringBuffer.toString();
                if (bl) {
                    return new StringBufferInputStream(string2);
                }
                return string2;
            }
            boolean bl3 = false;
            if (string.indexOf(":asBinaryString") > 0) {
                string = string.substring(0, string.indexOf(":asBinaryString"));
                bl3 = true;
            }
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!string.equals(zipEntry.getName())) continue;
                byte[] byArray = ZipUtil.getZipEntryAsBytes(zipInputStream);
                if (ZipUtil.isZipFile(byArray)) {
                    return ZipUtil.getZipFileContents(new BufferedInputStream(new ByteArrayInputStream(byArray)), stringArray, ++n, bl);
                }
                if (bl) {
                    return new ByteArrayInputStream(byArray);
                }
                if (bl3) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < byArray.length; ++i) {
                        stringBuffer.append(Integer.toHexString(byArray[i] & 0xFF)).append(' ');
                    }
                    return stringBuffer.toString();
                }
                return new String(byArray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static byte[] getZipFileContentsAsBytes(InputStream inputStream, String[] stringArray, int n) {
        byte[] byArray = new byte[]{};
        String string = stringArray[n];
        if (string.lastIndexOf("/") == string.length() - 1) {
            return byArray;
        }
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!string.equals(zipEntry.getName())) continue;
                byte[] byArray2 = ZipUtil.getZipEntryAsBytes(zipInputStream);
                if (ZipUtil.isZipFile(byArray2) && stringArray != null && ++n < stringArray.length) {
                    return ZipUtil.getZipFileContentsAsBytes(new BufferedInputStream(new ByteArrayInputStream(byArray2)), stringArray, n);
                }
                return byArray2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    public static String getZipDirectoryAsStringAndClose(InputStream inputStream) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[]{};
        try {
            stringArray = ZipUtil.getZipDirectoryOrErrorAndClose(inputStream, false);
            inputStream.close();
        }
        catch (Exception exception) {
            Logger.error(exception.getMessage());
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]).append('\n');
        }
        return stringBuffer.toString();
    }

    public static String[] getZipDirectoryAndClose(InputStream inputStream, boolean bl) {
        String[] stringArray = new String[]{};
        try {
            stringArray = ZipUtil.getZipDirectoryOrErrorAndClose(inputStream, bl);
            inputStream.close();
        }
        catch (Exception exception) {
            Logger.error(exception.getMessage());
        }
        return stringArray;
    }

    public static boolean isJmolManifest(String string) {
        return string.startsWith("JmolManifest");
    }

    private static String[] getZipDirectoryOrErrorAndClose(InputStream inputStream, boolean bl) throws IOException {
        ZipEntry zipEntry;
        Vector<String> vector = new Vector<String>();
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        String string = null;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string2 = zipEntry.getName();
            if (bl && ZipUtil.isJmolManifest(string2)) {
                string = ZipUtil.getZipEntryAsString(zipInputStream);
                continue;
            }
            if (string2.startsWith("__MACOS")) continue;
            vector.addElement(string2);
        }
        zipInputStream.close();
        if (bl) {
            vector.add(0, string == null ? "" : string + "\n############\n");
        }
        int n = vector.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public static String getZipEntryAsString(InputStream inputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = new byte[1024];
        while (inputStream.available() >= 1 && (n = inputStream.read(byArray)) > 0) {
            stringBuffer.append(new String(byArray, 0, n));
        }
        return stringBuffer.toString();
    }

    public static byte[] getZipEntryAsBytes(ZipInputStream zipInputStream) throws IOException {
        byte[] byArray = new byte[1024];
        byte[] byArray2 = new byte[4096];
        int n = 0;
        int n2 = 0;
        while (zipInputStream.available() == 1 && (n = zipInputStream.read(byArray)) > 0) {
            if ((n2 += n) >= byArray2.length) {
                byArray2 = ArrayUtil.ensureLength(byArray2, n2 * 2);
            }
            System.arraycopy(byArray, 0, byArray2, n2 - n, n);
        }
        byArray = new byte[n2];
        System.arraycopy(byArray2, 0, byArray, 0, n2);
        return byArray;
    }

    public static byte[] getStreamAsBytes(BufferedInputStream bufferedInputStream) throws IOException {
        byte[] byArray = new byte[1024];
        byte[] byArray2 = new byte[4096];
        int n = 0;
        int n2 = 0;
        while ((n = bufferedInputStream.read(byArray)) > 0) {
            if ((n2 += n) >= byArray2.length) {
                byArray2 = ArrayUtil.ensureLength(byArray2, n2 * 2);
            }
            System.arraycopy(byArray, 0, byArray2, n2 - n, n);
        }
        byArray = new byte[n2];
        System.arraycopy(byArray2, 0, byArray, 0, n2);
        return byArray;
    }

    public static boolean isGzip(byte[] byArray) {
        return byArray != null && byArray.length > 2 && byArray[0] == 31 && byArray[1] == -117;
    }

    public static boolean isGzip(InputStream inputStream) throws Exception {
        byte[] byArray = new byte[4];
        inputStream.mark(5);
        inputStream.read(byArray, 0, 4);
        inputStream.reset();
        return ZipUtil.isGzip(byArray);
    }

    public static String getGzippedBytesAsString(byte[] byArray) {
        try {
            InputStream inputStream = new ByteArrayInputStream(byArray);
            while (ZipUtil.isGzip(inputStream = new BufferedInputStream(new GZIPInputStream(inputStream)))) {
            }
            String string = ZipUtil.getZipEntryAsString(inputStream);
            inputStream.close();
            return string;
        }
        catch (Exception exception) {
            return "";
        }
    }
}

