/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ConfigurationType {
    OVF("ovf");

    private static final Logger log;
    private String image;

    private ConfigurationType(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static ConfigurationType fromValue(String value) {
        try {
            return ConfigurationType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'ConfigurationType' enumerated type. Valid value is 'ovf'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(ConfigurationType.class);
    }
}

