/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum MessageBrokerType {
    QPID("qpid"),
    RABBIT_MQ("rabbit_mq");

    private static final Logger log;
    private String image;

    private MessageBrokerType(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static MessageBrokerType fromValue(String value) {
        try {
            return MessageBrokerType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'MessageBrokerType' enumerated type. Valid values are 'qpid' and 'rabbit_mq'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(MessageBrokerType.class);
    }
}

