/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum VmStatus {
    DOWN("down"),
    IMAGE_LOCKED("image_locked"),
    MIGRATING("migrating"),
    NOT_RESPONDING("not_responding"),
    PAUSED("paused"),
    POWERING_DOWN("powering_down"),
    POWERING_UP("powering_up"),
    REBOOT_IN_PROGRESS("reboot_in_progress"),
    RESTORING_STATE("restoring_state"),
    SAVING_STATE("saving_state"),
    SUSPENDED("suspended"),
    UNASSIGNED("unassigned"),
    UNKNOWN("unknown"),
    UP("up"),
    WAIT_FOR_LAUNCH("wait_for_launch");

    private static final Logger log;
    private String image;

    private VmStatus(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static VmStatus fromValue(String value) {
        try {
            return VmStatus.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'VmStatus' enumerated type. Valid values are 'down', 'image_locked', 'migrating', 'not_responding', 'paused', 'powering_down', 'powering_up', 'reboot_in_progress', 'restoring_state', 'saving_state', 'suspended', 'unassigned', 'unknown', 'up' and 'wait_for_launch'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(VmStatus.class);
    }
}

