/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.lang.String;
import java.math.BigInteger;
import java.util.List;

public interface Action extends Identified {
    boolean allowPartialImport();
    
    boolean allowPartialImportPresent();
    
    boolean async();
    
    boolean asyncPresent();
    
    DiskAttachment attachment();
    
    boolean attachmentPresent();
    
    AuthorizedKey authorizedKey();
    
    boolean authorizedKeyPresent();
    
    List<GlusterBrick> bricks();
    
    boolean bricksPresent();
    
    List<Certificate> certificates();
    
    boolean certificatesPresent();
    
    boolean checkConnectivity();
    
    boolean checkConnectivityPresent();
    
    boolean clone_();
    
    boolean clone_Present();
    
    boolean clonePermissions();
    
    boolean clonePermissionsPresent();
    
    Cluster cluster();
    
    boolean clusterPresent();
    
    boolean collapseSnapshots();
    
    boolean collapseSnapshotsPresent();
    
    StorageConnection connection();
    
    boolean connectionPresent();
    
    BigInteger connectivityTimeout();
    Byte connectivityTimeoutAsByte();
    Short connectivityTimeoutAsShort();
    Integer connectivityTimeoutAsInteger();
    Long connectivityTimeoutAsLong();
    
    boolean connectivityTimeoutPresent();
    
    DataCenter dataCenter();
    
    boolean dataCenterPresent();
    
    boolean deployHostedEngine();
    
    boolean deployHostedEnginePresent();
    
    GlusterVolumeProfileDetails details();
    
    boolean detailsPresent();
    
    boolean discardSnapshots();
    
    boolean discardSnapshotsPresent();
    
    Disk disk();
    
    boolean diskPresent();
    
    List<Disk> disks();
    
    boolean disksPresent();
    
    boolean exclusive();
    
    boolean exclusivePresent();
    
    Fault fault();
    
    boolean faultPresent();
    
    String fenceType();
    
    boolean fenceTypePresent();
    
    boolean filter();
    
    boolean filterPresent();
    
    boolean fixLayout();
    
    boolean fixLayoutPresent();
    
    boolean force();
    
    boolean forcePresent();
    
    GracePeriod gracePeriod();
    
    boolean gracePeriodPresent();
    
    Host host();
    
    boolean hostPresent();
    
    String image();
    
    boolean imagePresent();
    
    ImageTransfer imageTransfer();
    
    boolean imageTransferPresent();
    
    boolean importAsTemplate();
    
    boolean importAsTemplatePresent();
    
    boolean isAttached();
    
    boolean isAttachedPresent();
    
    IscsiDetails iscsi();
    
    boolean iscsiPresent();
    
    List<String> iscsiTargets();
    
    boolean iscsiTargetsPresent();
    
    Job job();
    
    boolean jobPresent();
    
    List<LogicalUnit> logicalUnits();
    
    boolean logicalUnitsPresent();
    
    boolean maintenanceEnabled();
    
    boolean maintenanceEnabledPresent();
    
    List<HostNic> modifiedBonds();
    
    boolean modifiedBondsPresent();
    
    List<NetworkLabel> modifiedLabels();
    
    boolean modifiedLabelsPresent();
    
    List<NetworkAttachment> modifiedNetworkAttachments();
    
    boolean modifiedNetworkAttachmentsPresent();
    
    Option option();
    
    boolean optionPresent();
    
    boolean pause();
    
    boolean pausePresent();
    
    Permission permission();
    
    boolean permissionPresent();
    
    PowerManagement powerManagement();
    
    boolean powerManagementPresent();
    
    ProxyTicket proxyTicket();
    
    boolean proxyTicketPresent();
    
    String reason();
    
    boolean reasonPresent();
    
    boolean reassignBadMacs();
    
    boolean reassignBadMacsPresent();
    
    String remoteViewerConnectionFile();
    
    boolean remoteViewerConnectionFilePresent();
    
    List<HostNic> removedBonds();
    
    boolean removedBondsPresent();
    
    List<NetworkLabel> removedLabels();
    
    boolean removedLabelsPresent();
    
    List<NetworkAttachment> removedNetworkAttachments();
    
    boolean removedNetworkAttachmentsPresent();
    
    String resolutionType();
    
    boolean resolutionTypePresent();
    
    boolean restoreMemory();
    
    boolean restoreMemoryPresent();
    
    String rootPassword();
    
    boolean rootPasswordPresent();
    
    Snapshot snapshot();
    
    boolean snapshotPresent();
    
    Ssh ssh();
    
    boolean sshPresent();
    
    String status();
    
    boolean statusPresent();
    
    boolean stopGlusterService();
    
    boolean stopGlusterServicePresent();
    
    StorageDomain storageDomain();
    
    boolean storageDomainPresent();
    
    List<StorageDomain> storageDomains();
    
    boolean storageDomainsPresent();
    
    boolean succeeded();
    
    boolean succeededPresent();
    
    List<NetworkAttachment> synchronizedNetworkAttachments();
    
    boolean synchronizedNetworkAttachmentsPresent();
    
    Template template();
    
    boolean templatePresent();
    
    Ticket ticket();
    
    boolean ticketPresent();
    
    boolean undeployHostedEngine();
    
    boolean undeployHostedEnginePresent();
    
    boolean useCloudInit();
    
    boolean useCloudInitPresent();
    
    boolean useSysprep();
    
    boolean useSysprepPresent();
    
    HostNicVirtualFunctionsConfiguration virtualFunctionsConfiguration();
    
    boolean virtualFunctionsConfigurationPresent();
    
    Vm vm();
    
    boolean vmPresent();
    
    List<VnicProfileMapping> vnicProfileMappings();
    
    boolean vnicProfileMappingsPresent();
    
    boolean volatile_();
    
    boolean volatile_Present();
    
}
