/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.WatchdogContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlInstanceTypeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlTemplateReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVmReader;
import org.ovirt.engine.sdk4.internal.xml.XmlWatchdogActionReader;
import org.ovirt.engine.sdk4.internal.xml.XmlWatchdogModelReader;
import org.ovirt.engine.sdk4.types.Vm;
import org.ovirt.engine.sdk4.types.Watchdog;

public class XmlWatchdogReader {
    public static Watchdog readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        WatchdogContainer object = new WatchdogContainer();
        block32: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block32;
                }
                case "id": {
                    object.id(image);
                    continue block32;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block33: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "action": {
                    object.action(XmlWatchdogActionReader.readOne(reader));
                    continue block33;
                }
                case "comment": {
                    object.comment(reader.readString());
                    continue block33;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block33;
                }
                case "instance_type": {
                    object.instanceType(XmlInstanceTypeReader.readOne(reader));
                    continue block33;
                }
                case "model": {
                    object.model(XmlWatchdogModelReader.readOne(reader));
                    continue block33;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block33;
                }
                case "template": {
                    object.template(XmlTemplateReader.readOne(reader));
                    continue block33;
                }
                case "vm": {
                    object.vm(XmlVmReader.readOne(reader));
                    continue block33;
                }
                case "vms": {
                    object.vms(XmlVmReader.readMany(reader));
                    continue block33;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block33;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlWatchdogReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<Watchdog> iterateMany(final XmlReader reader) {
        return new Iterator<Watchdog>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Watchdog next() {
                Watchdog next = XmlWatchdogReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Watchdog> readMany(XmlReader reader) {
        ArrayList<Watchdog> list = new ArrayList<Watchdog>();
        Iterator<Watchdog> iterator = XmlWatchdogReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(WatchdogContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "vms": {
                    ArrayListWithHref<Vm> list = new ArrayListWithHref<Vm>(object.vms());
                    list.href(href);
                    object.vms(list);
                    break;
                }
            }
        }
    }
}

