/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SnapshotType {
    ACTIVE("active"),
    PREVIEW("preview"),
    REGULAR("regular"),
    STATELESS("stateless");

    private static final Logger log;
    private String image;

    private SnapshotType(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static SnapshotType fromValue(String value) {
        try {
            return SnapshotType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'SnapshotType' enumerated type. Valid values are 'active', 'preview', 'regular' and 'stateless'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(SnapshotType.class);
    }
}

