/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.internal.containers.HardwareInformationContainer;
import org.ovirt.engine.sdk4.types.HardwareInformation;
import org.ovirt.engine.sdk4.types.RngSource;

public class HardwareInformationBuilder {
    private String family;
    private String manufacturer;
    private String productName;
    private String serialNumber;
    private List<RngSource> supportedRngSources;
    private String uuid;
    private String version;

    public HardwareInformationBuilder family(String newFamily) {
        this.family = newFamily;
        return this;
    }

    public HardwareInformationBuilder manufacturer(String newManufacturer) {
        this.manufacturer = newManufacturer;
        return this;
    }

    public HardwareInformationBuilder productName(String newProductName) {
        this.productName = newProductName;
        return this;
    }

    public HardwareInformationBuilder serialNumber(String newSerialNumber) {
        this.serialNumber = newSerialNumber;
        return this;
    }

    public HardwareInformationBuilder supportedRngSources(List<RngSource> newSupportedRngSources) {
        if (newSupportedRngSources != null) {
            if (this.supportedRngSources == null) {
                this.supportedRngSources = new ArrayList<RngSource>(newSupportedRngSources);
            } else {
                this.supportedRngSources.addAll(newSupportedRngSources);
            }
        }
        return this;
    }

    public HardwareInformationBuilder supportedRngSources(RngSource ... newSupportedRngSources) {
        if (newSupportedRngSources != null) {
            if (this.supportedRngSources == null) {
                this.supportedRngSources = new ArrayList<RngSource>(newSupportedRngSources.length);
            }
            Collections.addAll(this.supportedRngSources, newSupportedRngSources);
        }
        return this;
    }

    public HardwareInformationBuilder uuid(String newUuid) {
        this.uuid = newUuid;
        return this;
    }

    public HardwareInformationBuilder version(String newVersion) {
        this.version = newVersion;
        return this;
    }

    public HardwareInformation build() {
        HardwareInformationContainer container = new HardwareInformationContainer();
        container.family(this.family);
        container.manufacturer(this.manufacturer);
        container.productName(this.productName);
        container.serialNumber(this.serialNumber);
        container.supportedRngSources(this.supportedRngSources);
        container.uuid(this.uuid);
        container.version(this.version);
        return container;
    }
}

