/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.lang.String;
import org.ovirt.engine.sdk4.internal.containers.PropertyContainer;
import org.ovirt.engine.sdk4.types.Property;

public class PropertyBuilder {
    private String name;
    private String value;
    
    public PropertyBuilder name(String newName) {
        name = newName;
        return this;
    }
    
    
    public PropertyBuilder value(String newValue) {
        value = newValue;
        return this;
    }
    
    
    public Property build() {
        PropertyContainer container = new PropertyContainer();
        container.name(name);
        container.value(value);
        return container;
    }
}
