/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.api.metamodel.runtime.xml;

import com.sun.xml.txw2.output.IndentingXMLStreamWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.ovirt.api.metamodel.runtime.xml.XmlException;

public class XmlWriter
implements AutoCloseable {
    private XMLStreamWriter writer;
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            return format;
        }
    };

    public XmlWriter(Result result, boolean indent) {
        this.init(result, indent);
    }

    public XmlWriter(OutputStream out, boolean indent) {
        OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        StreamResult result = new StreamResult(writer);
        this.init(result, indent);
    }

    public XmlWriter(Writer out, boolean indent) {
        StreamResult result = new StreamResult(out);
        this.init(result, indent);
    }

    public XmlWriter(File file, boolean indent) {
        try {
            FileOutputStream out = new FileOutputStream(file);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
            StreamResult result = new StreamResult(writer);
            this.init(result, indent);
        }
        catch (IOException exception) {
            throw new XmlException("Can't open file \"" + file.getAbsolutePath() + "\" for writing", exception);
        }
    }

    private void init(Result result, boolean indent) {
        try {
            XMLOutputFactory factory = XMLOutputFactory.newFactory();
            this.writer = factory.createXMLStreamWriter(result);
            if (indent) {
                IndentingXMLStreamWriter indenter = new IndentingXMLStreamWriter(this.writer);
                indenter.setIndentStep("  ");
                this.writer = indenter;
            }
        }
        catch (XMLStreamException exception) {
            throw new XmlException("Can't create XML writer", exception);
        }
    }

    public void writeStartDocument(String encoding, String version) {
        try {
            this.writer.writeStartDocument(encoding, version);
        }
        catch (XMLStreamException exception) {
            throw new XmlException("Can't write start of document", exception);
        }
    }

    public void writeEndDocument() {
        try {
            this.writer.writeEndDocument();
        }
        catch (XMLStreamException exception) {
            throw new XmlException("Can't write end of document", exception);
        }
    }

    public void setPrefix(String prefix, String uri) {
        try {
            this.writer.setPrefix(prefix, uri);
        }
        catch (XMLStreamException exception) {
            throw new XmlException("Can't associate prefix \"" + prefix + "\" with URI \"" + uri + "\"", exception);
        }
    }

    public void writeElement(String uri, String name, String value) {
        this.writeStartElement(uri, name);
        this.writeCharacters(value);
        this.writeEndElement();
    }

    public void writeElement(String name, String value) {
        this.writeStartElement(name);
        this.writeCharacters(value);
        this.writeEndElement();
    }

    public void writeStartElement(String uri, String name) {
        try {
            this.writer.writeStartElement(uri, name);
        }
        catch (XMLStreamException exception) {
            throw new XmlException("Can't write start element for tag \"" + name + "\"", exception);
        }
    }

    public void writeStartElement(String name) {
        try {
            this.writer.writeStartElement(name);
        }
        catch (XMLStreamException exception) {
            throw new XmlException("Can't write start element for tag \"" + name + "\"", exception);
        }
    }

    public void writeEndElement() {
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException exception) {
            throw new XmlException("Can't write end element", exception);
        }
    }

    public void writeAttribute(String name, String value) {
        try {
            this.writer.writeAttribute(name, value);
        }
        catch (XMLStreamException exception) {
            throw new XmlException("Can't write attribute with name \"" + name + "\" and value \"" + value + "\"", exception);
        }
    }

    public void writeCharacters(String text) {
        try {
            this.writer.writeCharacters(text);
        }
        catch (XMLStreamException exception) {
            throw new XmlException("Can't write text \"" + text + "\"", exception);
        }
    }

    public void writeLine() {
        this.writeCharacters("\n");
    }

    public void writeBoolean(String name, boolean value) {
        this.writeElement(name, XmlWriter.renderBoolean(value));
    }

    public void writeInteger(String name, BigInteger value) {
        this.writeElement(name, XmlWriter.renderInteger(value));
    }

    public void writeDecimal(String name, BigDecimal value) {
        this.writeElement(name, XmlWriter.renderDecimal(value));
    }

    public void writeDate(String name, Date value) {
        this.writeElement(name, XmlWriter.renderDate(value));
    }

    public void writeString(String name, String value) {
        this.writeElement(name, XmlWriter.renderString(value));
    }

    public void writeBooleans(String name, List<Boolean> values) {
        for (Boolean value : values) {
            this.writeBoolean(name, value);
        }
    }

    public void writeIntegers(String name, List<BigInteger> values) {
        for (BigInteger value : values) {
            this.writeInteger(name, value);
        }
    }

    public void writeDecimals(String name, List<BigDecimal> values) {
        for (BigDecimal value : values) {
            this.writeDecimal(name, value);
        }
    }

    public void writeDates(String name, List<Date> values) {
        for (Date value : values) {
            this.writeDate(name, value);
        }
    }

    public void writeElements(String name, List<String> values) {
        for (String value : values) {
            this.writeElement(name, value);
        }
    }

    public static String renderString(String value) {
        return value;
    }

    public static String renderBoolean(boolean value) {
        return Boolean.toString(value);
    }

    public static String renderInteger(BigInteger value) {
        return value.toString();
    }

    public static String renderDecimal(BigDecimal value) {
        return value.toString();
    }

    public static String renderDate(Date value) {
        return DATE_FORMAT.get().format(value);
    }

    public void flush() {
        try {
            this.writer.flush();
        }
        catch (XMLStreamException exception) {
            throw new XmlException("Can't flush", exception);
        }
    }

    @Override
    public void close() {
        try {
            this.writer.writeEndDocument();
            this.writer.close();
        }
        catch (XMLStreamException exception) {
            throw new XmlException("Can't close", exception);
        }
    }
}

