/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.ovirt.engine.sdk4.builders.HostBuilder;
import org.ovirt.engine.sdk4.builders.PackageBuilder;
import org.ovirt.engine.sdk4.builders.VmBuilder;
import org.ovirt.engine.sdk4.internal.containers.KatelloErratumContainer;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.KatelloErratum;
import org.ovirt.engine.sdk4.types.Package;
import org.ovirt.engine.sdk4.types.Vm;

public class KatelloErratumBuilder {
    private String comment;
    private String description;
    private Host host;
    private String href;
    private String id;
    private Date issued;
    private String name;
    private List<Package> packages;
    private String severity;
    private String solution;
    private String summary;
    private String title;
    private String type;
    private Vm vm;

    public KatelloErratumBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public KatelloErratumBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public KatelloErratumBuilder host(Host newHost) {
        this.host = newHost;
        return this;
    }

    public KatelloErratumBuilder host(HostBuilder newHost) {
        this.host = newHost == null ? null : newHost.build();
        return this;
    }

    public KatelloErratumBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public KatelloErratumBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public KatelloErratumBuilder issued(Date newIssued) {
        this.issued = newIssued == null ? null : new Date(newIssued.getTime());
        return this;
    }

    public KatelloErratumBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public KatelloErratumBuilder packages(List<Package> newPackages) {
        if (newPackages != null) {
            if (this.packages == null) {
                this.packages = new ArrayList<Package>(newPackages);
            } else {
                this.packages.addAll(newPackages);
            }
        }
        return this;
    }

    public KatelloErratumBuilder packages(Package ... newPackages) {
        if (newPackages != null) {
            if (this.packages == null) {
                this.packages = new ArrayList<Package>(newPackages.length);
            }
            Collections.addAll(this.packages, newPackages);
        }
        return this;
    }

    public KatelloErratumBuilder packages(PackageBuilder ... newPackages) {
        if (newPackages != null) {
            if (this.packages == null) {
                this.packages = new ArrayList<Package>(newPackages.length);
            }
            for (PackageBuilder builder : newPackages) {
                this.packages.add(builder.build());
            }
        }
        return this;
    }

    public KatelloErratumBuilder severity(String newSeverity) {
        this.severity = newSeverity;
        return this;
    }

    public KatelloErratumBuilder solution(String newSolution) {
        this.solution = newSolution;
        return this;
    }

    public KatelloErratumBuilder summary(String newSummary) {
        this.summary = newSummary;
        return this;
    }

    public KatelloErratumBuilder title(String newTitle) {
        this.title = newTitle;
        return this;
    }

    public KatelloErratumBuilder type(String newType) {
        this.type = newType;
        return this;
    }

    public KatelloErratumBuilder vm(Vm newVm) {
        this.vm = newVm;
        return this;
    }

    public KatelloErratumBuilder vm(VmBuilder newVm) {
        this.vm = newVm == null ? null : newVm.build();
        return this;
    }

    public KatelloErratum build() {
        KatelloErratumContainer container = new KatelloErratumContainer();
        container.comment(this.comment);
        container.description(this.description);
        container.host(this.host);
        container.href(this.href);
        container.id(this.id);
        container.issued(this.issued);
        container.name(this.name);
        container.packages(this.packages);
        container.severity(this.severity);
        container.solution(this.solution);
        container.summary(this.summary);
        container.title(this.title);
        container.type(this.type);
        container.vm(this.vm);
        return container;
    }
}

