/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum InheritableBoolean {
    FALSE("false"),
    INHERIT("inherit"),
    TRUE("true");

    private static final Logger log;
    private String image;

    private InheritableBoolean(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static InheritableBoolean fromValue(String value) {
        try {
            return InheritableBoolean.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'InheritableBoolean' enumerated type. Valid values are 'false', 'inherit' and 'true'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(InheritableBoolean.class);
    }
}

