/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.api.metamodel.runtime.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ovirt.api.metamodel.runtime.xml.XmlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlReader
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(XmlReader.class);
    private static Map<String, Method> readers = new HashMap<String, Method>();
    public static final String METHODS_FILE = "methods.properties";
    private XMLStreamReader reader;
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMAT;

    public XmlReader(Source source) {
        this.init(source);
    }

    public XmlReader(InputStream in) {
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        StreamSource source = new StreamSource(reader);
        this.init(source);
    }

    public XmlReader(Reader in) {
        StreamSource source = new StreamSource(in);
        this.init(source);
    }

    public XmlReader(File file) {
        try {
            FileInputStream in = new FileInputStream(file);
            InputStreamReader reader = new InputStreamReader((InputStream)in, StandardCharsets.UTF_8);
            StreamSource source = new StreamSource(reader);
            this.init(source);
        }
        catch (IOException exception) {
            throw new XmlException("Can't open file \"" + file.getAbsolutePath() + "\" for reading", exception);
        }
    }

    private void init(Source source) {
        try {
            XMLInputFactory factory = XMLInputFactory.newFactory();
            this.reader = factory.createXMLStreamReader(source);
        }
        catch (XMLStreamException exception) {
            throw new XmlException("Can't create XML reader", exception);
        }
    }

    public int getAttributeCount() {
        return this.reader.getAttributeCount();
    }

    public String getAttributeLocalName(int index) {
        return this.reader.getAttributeLocalName(index);
    }

    public String getAttributeValue(int index) {
        return this.reader.getAttributeValue(index);
    }

    public String getAttributeValue(String name) {
        return this.reader.getAttributeValue(null, name);
    }

    public int next() {
        try {
            return this.reader.next();
        }
        catch (XMLStreamException exception) {
            throw new XmlException("Can't get next event", exception);
        }
    }

    public String getLocalName() {
        return this.reader.getLocalName();
    }

    public int getEventType() {
        return this.reader.getEventType();
    }

    public boolean forward() {
        while (true) {
            switch (this.reader.getEventType()) {
                case 1: {
                    return true;
                }
                case 2: 
                case 8: {
                    return false;
                }
            }
            try {
                this.reader.next();
            }
            catch (XMLStreamException exception) {
                throw new XmlException("Can't get next event", exception);
            }
        }
    }

    public void skip() {
        int depth = 0;
        while (true) {
            switch (this.reader.getEventType()) {
                case 1: {
                    ++depth;
                    break;
                }
                case 2: {
                    if (--depth > 0) break;
                    try {
                        this.reader.next();
                    }
                    catch (XMLStreamException exception) {
                        throw new XmlException("Can't get next event", exception);
                    }
                    return;
                }
                case 8: {
                    return;
                }
            }
            try {
                this.reader.next();
            }
            catch (XMLStreamException exception) {
                throw new XmlException("Can't get next event", exception);
            }
        }
    }

    public boolean readBoolean() {
        return this.parseBoolean(this.readString());
    }

    public BigInteger readInteger() {
        return this.parseInteger(this.readString());
    }

    public BigDecimal readDecimal() {
        return this.parseDecimal(this.readString());
    }

    public String readString() {
        try {
            String string = this.reader.getElementText();
            return string;
        }
        catch (XMLStreamException exception) {
            throw new XmlException("Can't get element text", exception);
        }
        finally {
            try {
                this.reader.next();
            }
            catch (XMLStreamException exception) {
                throw new XmlException("Can't get next event", exception);
            }
        }
    }

    public Date readDate() {
        return this.parseDate(this.readString());
    }

    public List<Boolean> readBooleans() {
        ArrayList<Boolean> booleans = new ArrayList<Boolean>();
        for (String string : this.readStrings()) {
            booleans.add(this.parseBoolean(string));
        }
        return booleans;
    }

    public List<BigInteger> readIntegers() {
        ArrayList<BigInteger> integers = new ArrayList<BigInteger>();
        for (String string : this.readStrings()) {
            integers.add(this.parseInteger(string));
        }
        return integers;
    }

    public List<BigDecimal> readDecimals() {
        ArrayList<BigDecimal> decimals = new ArrayList<BigDecimal>();
        for (String string : this.readStrings()) {
            decimals.add(this.parseDecimal(string));
        }
        return decimals;
    }

    public List<Date> readDates() {
        ArrayList<Date> dates = new ArrayList<Date>();
        for (String string : this.readStrings()) {
            dates.add(this.parseDate(string));
        }
        return dates;
    }

    public List<String> readStrings() {
        String startingLocalName;
        ArrayList<String> values = new ArrayList<String>();
        String currentLocalName = startingLocalName = this.reader.getLocalName();
        this.next();
        boolean forward = true;
        while (forward) {
            forward = this.forward();
            currentLocalName = this.reader.getLocalName();
            if (!forward && currentLocalName.equals(startingLocalName)) {
                this.skip();
                continue;
            }
            values.add(this.readString());
        }
        return values;
    }

    public BigInteger parseInteger(String image) {
        try {
            return new BigInteger(image);
        }
        catch (NumberFormatException exception) {
            throw new XmlException("The text \"" + image + "\" isn't a valid integer value");
        }
    }

    public BigDecimal parseDecimal(String image) {
        try {
            return new BigDecimal(image).stripTrailingZeros();
        }
        catch (NumberFormatException exception) {
            throw new XmlException("The text \"" + image + "\" isn't a valid decimal value");
        }
    }

    public Date parseDate(String image) {
        try {
            return DATE_FORMAT.get().parse(image);
        }
        catch (ParseException exception) {
            throw new XmlException("The text \"" + image + "\" isn't a valid date value");
        }
    }

    public boolean parseBoolean(String image) {
        if (image.equalsIgnoreCase("false") || image.equals("0")) {
            return false;
        }
        if (image.equalsIgnoreCase("true") || image.equals("1")) {
            return true;
        }
        throw new XmlException("The text \"" + image + "\" isn't a valid boolean value");
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (XMLStreamException exception) {
            throw new XmlException("Can't close", exception);
        }
    }

    public static void register(String tag, Method reader) {
        readers.put(tag, reader);
    }

    public Object read() {
        String tag = null;
        Method method = null;
        try {
            if (!this.forward()) {
                Object var3_3 = null;
                return var3_3;
            }
            tag = this.getLocalName();
            method = readers.get(tag);
            if (method == null) {
                throw new RuntimeException(String.format("Can't find a reader for tag '%s'", tag));
            }
            Object object = method.invoke(null, this);
            return object;
        }
        catch (IllegalAccessException | InvocationTargetException exception) {
            throw new RuntimeException(String.format("Failed to invoke method '%1$s' to read element for tag '%2$s'", method, tag), exception);
        }
        finally {
            this.close();
        }
    }

    static {
        try (InputStream in = XmlReader.class.getResourceAsStream(METHODS_FILE);
             InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
            Properties props = new Properties();
            props.load(reader);
            Enumeration<?> propertiesEnumeration = props.propertyNames();
            while (propertiesEnumeration.hasMoreElements()) {
                String key = (String)propertiesEnumeration.nextElement();
                String value = props.getProperty(key);
                String className = value.substring(0, value.lastIndexOf("."));
                String methodName = value.substring(value.lastIndexOf(".") + 1);
                Class<?> clazz = Class.forName(className);
                XmlReader.register(key, clazz.getDeclaredMethod(methodName, XmlReader.class));
            }
        }
        catch (Exception e) {
            log.error("methods.properties file wasn't found: {}", (Object)e.getMessage());
            log.debug("Exception:", (Throwable)e);
        }
        DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                return format;
            }
        };
    }
}

