/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.AuthorizedKeyBuilder;
import org.ovirt.engine.sdk4.builders.FileBuilder;
import org.ovirt.engine.sdk4.builders.HostBuilder;
import org.ovirt.engine.sdk4.builders.NetworkConfigurationBuilder;
import org.ovirt.engine.sdk4.builders.UserBuilder;
import org.ovirt.engine.sdk4.internal.containers.CloudInitContainer;
import org.ovirt.engine.sdk4.types.AuthorizedKey;
import org.ovirt.engine.sdk4.types.CloudInit;
import org.ovirt.engine.sdk4.types.File;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.NetworkConfiguration;
import org.ovirt.engine.sdk4.types.User;

public class CloudInitBuilder {
    private List<AuthorizedKey> authorizedKeys;
    private List<File> files;
    private Host host;
    private NetworkConfiguration networkConfiguration;
    private Boolean regenerateSshKeys;
    private String timezone;
    private List<User> users;

    public CloudInitBuilder authorizedKeys(List<AuthorizedKey> newAuthorizedKeys) {
        if (newAuthorizedKeys != null) {
            if (this.authorizedKeys == null) {
                this.authorizedKeys = new ArrayList<AuthorizedKey>(newAuthorizedKeys);
            } else {
                this.authorizedKeys.addAll(newAuthorizedKeys);
            }
        }
        return this;
    }

    public CloudInitBuilder authorizedKeys(AuthorizedKey ... newAuthorizedKeys) {
        if (newAuthorizedKeys != null) {
            if (this.authorizedKeys == null) {
                this.authorizedKeys = new ArrayList<AuthorizedKey>(newAuthorizedKeys.length);
            }
            Collections.addAll(this.authorizedKeys, newAuthorizedKeys);
        }
        return this;
    }

    public CloudInitBuilder authorizedKeys(AuthorizedKeyBuilder ... newAuthorizedKeys) {
        if (newAuthorizedKeys != null) {
            if (this.authorizedKeys == null) {
                this.authorizedKeys = new ArrayList<AuthorizedKey>(newAuthorizedKeys.length);
            }
            for (AuthorizedKeyBuilder builder : newAuthorizedKeys) {
                this.authorizedKeys.add(builder.build());
            }
        }
        return this;
    }

    public CloudInitBuilder files(List<File> newFiles) {
        if (newFiles != null) {
            if (this.files == null) {
                this.files = new ArrayList<File>(newFiles);
            } else {
                this.files.addAll(newFiles);
            }
        }
        return this;
    }

    public CloudInitBuilder files(File ... newFiles) {
        if (newFiles != null) {
            if (this.files == null) {
                this.files = new ArrayList<File>(newFiles.length);
            }
            Collections.addAll(this.files, newFiles);
        }
        return this;
    }

    public CloudInitBuilder files(FileBuilder ... newFiles) {
        if (newFiles != null) {
            if (this.files == null) {
                this.files = new ArrayList<File>(newFiles.length);
            }
            for (FileBuilder builder : newFiles) {
                this.files.add(builder.build());
            }
        }
        return this;
    }

    public CloudInitBuilder host(Host newHost) {
        this.host = newHost;
        return this;
    }

    public CloudInitBuilder host(HostBuilder newHost) {
        this.host = newHost == null ? null : newHost.build();
        return this;
    }

    public CloudInitBuilder networkConfiguration(NetworkConfiguration newNetworkConfiguration) {
        this.networkConfiguration = newNetworkConfiguration;
        return this;
    }

    public CloudInitBuilder networkConfiguration(NetworkConfigurationBuilder newNetworkConfiguration) {
        this.networkConfiguration = newNetworkConfiguration == null ? null : newNetworkConfiguration.build();
        return this;
    }

    public CloudInitBuilder regenerateSshKeys(boolean newRegenerateSshKeys) {
        this.regenerateSshKeys = newRegenerateSshKeys;
        return this;
    }

    public CloudInitBuilder regenerateSshKeys(Boolean newRegenerateSshKeys) {
        this.regenerateSshKeys = newRegenerateSshKeys;
        return this;
    }

    public CloudInitBuilder timezone(String newTimezone) {
        this.timezone = newTimezone;
        return this;
    }

    public CloudInitBuilder users(List<User> newUsers) {
        if (newUsers != null) {
            if (this.users == null) {
                this.users = new ArrayList<User>(newUsers);
            } else {
                this.users.addAll(newUsers);
            }
        }
        return this;
    }

    public CloudInitBuilder users(User ... newUsers) {
        if (newUsers != null) {
            if (this.users == null) {
                this.users = new ArrayList<User>(newUsers.length);
            }
            Collections.addAll(this.users, newUsers);
        }
        return this;
    }

    public CloudInitBuilder users(UserBuilder ... newUsers) {
        if (newUsers != null) {
            if (this.users == null) {
                this.users = new ArrayList<User>(newUsers.length);
            }
            for (UserBuilder builder : newUsers) {
                this.users.add(builder.build());
            }
        }
        return this;
    }

    public CloudInit build() {
        CloudInitContainer container = new CloudInitContainer();
        container.authorizedKeys(this.authorizedKeys);
        container.files(this.files);
        container.host(this.host);
        container.networkConfiguration(this.networkConfiguration);
        container.regenerateSshKeys(this.regenerateSshKeys);
        container.timezone(this.timezone);
        container.users(this.users);
        return container;
    }
}

