/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.AgentConfigurationBuilder;
import org.ovirt.engine.sdk4.builders.CertificateBuilder;
import org.ovirt.engine.sdk4.builders.OpenStackNetworkBuilder;
import org.ovirt.engine.sdk4.builders.OpenStackSubnetBuilder;
import org.ovirt.engine.sdk4.builders.PropertyBuilder;
import org.ovirt.engine.sdk4.internal.containers.OpenStackNetworkProviderContainer;
import org.ovirt.engine.sdk4.types.AgentConfiguration;
import org.ovirt.engine.sdk4.types.Certificate;
import org.ovirt.engine.sdk4.types.NetworkPluginType;
import org.ovirt.engine.sdk4.types.OpenStackNetwork;
import org.ovirt.engine.sdk4.types.OpenStackNetworkProvider;
import org.ovirt.engine.sdk4.types.OpenStackNetworkProviderType;
import org.ovirt.engine.sdk4.types.OpenStackSubnet;
import org.ovirt.engine.sdk4.types.Property;

public class OpenStackNetworkProviderBuilder {
    private AgentConfiguration agentConfiguration;
    private String authenticationUrl;
    private Boolean autoSync;
    private List<Certificate> certificates;
    private String comment;
    private String description;
    private String externalPluginType;
    private String href;
    private String id;
    private String name;
    private List<OpenStackNetwork> networks;
    private String password;
    private NetworkPluginType pluginType;
    private String projectDomainName;
    private String projectName;
    private List<Property> properties;
    private Boolean readOnly;
    private Boolean requiresAuthentication;
    private List<OpenStackSubnet> subnets;
    private String tenantName;
    private OpenStackNetworkProviderType type;
    private Boolean unmanaged;
    private String url;
    private String userDomainName;
    private String username;

    public OpenStackNetworkProviderBuilder agentConfiguration(AgentConfiguration newAgentConfiguration) {
        this.agentConfiguration = newAgentConfiguration;
        return this;
    }

    public OpenStackNetworkProviderBuilder agentConfiguration(AgentConfigurationBuilder newAgentConfiguration) {
        this.agentConfiguration = newAgentConfiguration == null ? null : newAgentConfiguration.build();
        return this;
    }

    public OpenStackNetworkProviderBuilder authenticationUrl(String newAuthenticationUrl) {
        this.authenticationUrl = newAuthenticationUrl;
        return this;
    }

    public OpenStackNetworkProviderBuilder autoSync(boolean newAutoSync) {
        this.autoSync = newAutoSync;
        return this;
    }

    public OpenStackNetworkProviderBuilder autoSync(Boolean newAutoSync) {
        this.autoSync = newAutoSync;
        return this;
    }

    public OpenStackNetworkProviderBuilder certificates(List<Certificate> newCertificates) {
        if (newCertificates != null) {
            if (this.certificates == null) {
                this.certificates = new ArrayList<Certificate>(newCertificates);
            } else {
                this.certificates.addAll(newCertificates);
            }
        }
        return this;
    }

    public OpenStackNetworkProviderBuilder certificates(Certificate ... newCertificates) {
        if (newCertificates != null) {
            if (this.certificates == null) {
                this.certificates = new ArrayList<Certificate>(newCertificates.length);
            }
            Collections.addAll(this.certificates, newCertificates);
        }
        return this;
    }

    public OpenStackNetworkProviderBuilder certificates(CertificateBuilder ... newCertificates) {
        if (newCertificates != null) {
            if (this.certificates == null) {
                this.certificates = new ArrayList<Certificate>(newCertificates.length);
            }
            for (CertificateBuilder builder : newCertificates) {
                this.certificates.add(builder.build());
            }
        }
        return this;
    }

    public OpenStackNetworkProviderBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public OpenStackNetworkProviderBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public OpenStackNetworkProviderBuilder externalPluginType(String newExternalPluginType) {
        this.externalPluginType = newExternalPluginType;
        return this;
    }

    public OpenStackNetworkProviderBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public OpenStackNetworkProviderBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public OpenStackNetworkProviderBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public OpenStackNetworkProviderBuilder networks(List<OpenStackNetwork> newNetworks) {
        if (newNetworks != null) {
            if (this.networks == null) {
                this.networks = new ArrayList<OpenStackNetwork>(newNetworks);
            } else {
                this.networks.addAll(newNetworks);
            }
        }
        return this;
    }

    public OpenStackNetworkProviderBuilder networks(OpenStackNetwork ... newNetworks) {
        if (newNetworks != null) {
            if (this.networks == null) {
                this.networks = new ArrayList<OpenStackNetwork>(newNetworks.length);
            }
            Collections.addAll(this.networks, newNetworks);
        }
        return this;
    }

    public OpenStackNetworkProviderBuilder networks(OpenStackNetworkBuilder ... newNetworks) {
        if (newNetworks != null) {
            if (this.networks == null) {
                this.networks = new ArrayList<OpenStackNetwork>(newNetworks.length);
            }
            for (OpenStackNetworkBuilder builder : newNetworks) {
                this.networks.add(builder.build());
            }
        }
        return this;
    }

    public OpenStackNetworkProviderBuilder password(String newPassword) {
        this.password = newPassword;
        return this;
    }

    public OpenStackNetworkProviderBuilder pluginType(NetworkPluginType newPluginType) {
        this.pluginType = newPluginType;
        return this;
    }

    public OpenStackNetworkProviderBuilder projectDomainName(String newProjectDomainName) {
        this.projectDomainName = newProjectDomainName;
        return this;
    }

    public OpenStackNetworkProviderBuilder projectName(String newProjectName) {
        this.projectName = newProjectName;
        return this;
    }

    public OpenStackNetworkProviderBuilder properties(List<Property> newProperties) {
        if (newProperties != null) {
            if (this.properties == null) {
                this.properties = new ArrayList<Property>(newProperties);
            } else {
                this.properties.addAll(newProperties);
            }
        }
        return this;
    }

    public OpenStackNetworkProviderBuilder properties(Property ... newProperties) {
        if (newProperties != null) {
            if (this.properties == null) {
                this.properties = new ArrayList<Property>(newProperties.length);
            }
            Collections.addAll(this.properties, newProperties);
        }
        return this;
    }

    public OpenStackNetworkProviderBuilder properties(PropertyBuilder ... newProperties) {
        if (newProperties != null) {
            if (this.properties == null) {
                this.properties = new ArrayList<Property>(newProperties.length);
            }
            for (PropertyBuilder builder : newProperties) {
                this.properties.add(builder.build());
            }
        }
        return this;
    }

    public OpenStackNetworkProviderBuilder readOnly(boolean newReadOnly) {
        this.readOnly = newReadOnly;
        return this;
    }

    public OpenStackNetworkProviderBuilder readOnly(Boolean newReadOnly) {
        this.readOnly = newReadOnly;
        return this;
    }

    public OpenStackNetworkProviderBuilder requiresAuthentication(boolean newRequiresAuthentication) {
        this.requiresAuthentication = newRequiresAuthentication;
        return this;
    }

    public OpenStackNetworkProviderBuilder requiresAuthentication(Boolean newRequiresAuthentication) {
        this.requiresAuthentication = newRequiresAuthentication;
        return this;
    }

    public OpenStackNetworkProviderBuilder subnets(List<OpenStackSubnet> newSubnets) {
        if (newSubnets != null) {
            if (this.subnets == null) {
                this.subnets = new ArrayList<OpenStackSubnet>(newSubnets);
            } else {
                this.subnets.addAll(newSubnets);
            }
        }
        return this;
    }

    public OpenStackNetworkProviderBuilder subnets(OpenStackSubnet ... newSubnets) {
        if (newSubnets != null) {
            if (this.subnets == null) {
                this.subnets = new ArrayList<OpenStackSubnet>(newSubnets.length);
            }
            Collections.addAll(this.subnets, newSubnets);
        }
        return this;
    }

    public OpenStackNetworkProviderBuilder subnets(OpenStackSubnetBuilder ... newSubnets) {
        if (newSubnets != null) {
            if (this.subnets == null) {
                this.subnets = new ArrayList<OpenStackSubnet>(newSubnets.length);
            }
            for (OpenStackSubnetBuilder builder : newSubnets) {
                this.subnets.add(builder.build());
            }
        }
        return this;
    }

    public OpenStackNetworkProviderBuilder tenantName(String newTenantName) {
        this.tenantName = newTenantName;
        return this;
    }

    public OpenStackNetworkProviderBuilder type(OpenStackNetworkProviderType newType) {
        this.type = newType;
        return this;
    }

    public OpenStackNetworkProviderBuilder unmanaged(boolean newUnmanaged) {
        this.unmanaged = newUnmanaged;
        return this;
    }

    public OpenStackNetworkProviderBuilder unmanaged(Boolean newUnmanaged) {
        this.unmanaged = newUnmanaged;
        return this;
    }

    public OpenStackNetworkProviderBuilder url(String newUrl) {
        this.url = newUrl;
        return this;
    }

    public OpenStackNetworkProviderBuilder userDomainName(String newUserDomainName) {
        this.userDomainName = newUserDomainName;
        return this;
    }

    public OpenStackNetworkProviderBuilder username(String newUsername) {
        this.username = newUsername;
        return this;
    }

    public OpenStackNetworkProvider build() {
        OpenStackNetworkProviderContainer container = new OpenStackNetworkProviderContainer();
        container.agentConfiguration(this.agentConfiguration);
        container.authenticationUrl(this.authenticationUrl);
        container.autoSync(this.autoSync);
        container.certificates(this.certificates);
        container.comment(this.comment);
        container.description(this.description);
        container.externalPluginType(this.externalPluginType);
        container.href(this.href);
        container.id(this.id);
        container.name(this.name);
        container.networks(this.networks);
        container.password(this.password);
        container.pluginType(this.pluginType);
        container.projectDomainName(this.projectDomainName);
        container.projectName(this.projectName);
        container.properties(this.properties);
        container.readOnly(this.readOnly);
        container.requiresAuthentication(this.requiresAuthentication);
        container.subnets(this.subnets);
        container.tenantName(this.tenantName);
        container.type(this.type);
        container.unmanaged(this.unmanaged);
        container.url(this.url);
        container.userDomainName(this.userDomainName);
        container.username(this.username);
        return container;
    }
}

