/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.DataCenterIscsiBondNetwork;
import org.ovirt.engine.sdk.decorators.DataCenterIscsiBondNetworkPermission;
import org.ovirt.engine.sdk.entities.Permission;
import org.ovirt.engine.sdk.entities.Permissions;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class DataCenterIscsiBondNetworkPermissions
extends CollectionDecorator<Permission, Permissions, DataCenterIscsiBondNetworkPermission> {
    private DataCenterIscsiBondNetwork parent;

    public DataCenterIscsiBondNetworkPermissions(HttpProxyBroker proxy, DataCenterIscsiBondNetwork parent) {
        super(proxy, "permissions");
        this.parent = parent;
    }

    @Override
    public List<DataCenterIscsiBondNetworkPermission> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Permissions.class, DataCenterIscsiBondNetworkPermission.class);
    }

    @Override
    public DataCenterIscsiBondNetworkPermission get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Permission.class, DataCenterIscsiBondNetworkPermission.class);
    }

    @Override
    public DataCenterIscsiBondNetworkPermission getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, Permission.class, DataCenterIscsiBondNetworkPermission.class);
    }

    public DataCenterIscsiBondNetworkPermission add(Permission permission) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, permission, Permission.class, DataCenterIscsiBondNetworkPermission.class, headers);
    }

    public List<DataCenterIscsiBondNetworkPermission> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(this.parent.getHref() + "/" + this.getName());
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, Permissions.class, DataCenterIscsiBondNetworkPermission.class, headers);
    }
}

