/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.DataCenterNetwork;
import org.ovirt.engine.sdk.decorators.DataCenterNetworkLabel;
import org.ovirt.engine.sdk.entities.Label;
import org.ovirt.engine.sdk.entities.Labels;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class DataCenterNetworkLabels
extends CollectionDecorator<Label, Labels, DataCenterNetworkLabel> {
    private DataCenterNetwork parent;

    public DataCenterNetworkLabels(HttpProxyBroker proxy, DataCenterNetwork parent) {
        super(proxy, "labels");
        this.parent = parent;
    }

    @Override
    public List<DataCenterNetworkLabel> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Labels.class, DataCenterNetworkLabel.class);
    }

    @Override
    public DataCenterNetworkLabel get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Label.class, DataCenterNetworkLabel.class);
    }

    @Override
    public DataCenterNetworkLabel getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, Label.class, DataCenterNetworkLabel.class);
    }

    public DataCenterNetworkLabel add(Label label) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, label, Label.class, DataCenterNetworkLabel.class, headers);
    }

    public DataCenterNetworkLabel add(Label label, String expect) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, label, Label.class, DataCenterNetworkLabel.class, headers);
    }

    public DataCenterNetworkLabel add(Label label, String expect, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, label, Label.class, DataCenterNetworkLabel.class, headers);
    }

    public List<DataCenterNetworkLabel> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(this.parent.getHref() + "/" + this.getName());
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, Labels.class, DataCenterNetworkLabel.class, headers);
    }
}

