/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.ExternalHostProvider;
import org.ovirt.engine.sdk.decorators.ExternalHostProviderExternalHostGroup;
import org.ovirt.engine.sdk.entities.ExternalHostGroup;
import org.ovirt.engine.sdk.entities.ExternalHostGroups;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class ExternalHostProviderExternalHostGroups
extends CollectionDecorator<ExternalHostGroup, ExternalHostGroups, ExternalHostProviderExternalHostGroup> {
    private ExternalHostProvider parent;

    public ExternalHostProviderExternalHostGroups(HttpProxyBroker proxy, ExternalHostProvider parent) {
        super(proxy, "hostgroups");
        this.parent = parent;
    }

    @Override
    public List<ExternalHostProviderExternalHostGroup> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, ExternalHostGroups.class, ExternalHostProviderExternalHostGroup.class);
    }

    @Override
    public ExternalHostProviderExternalHostGroup get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, ExternalHostGroup.class, ExternalHostProviderExternalHostGroup.class);
    }

    @Override
    public ExternalHostProviderExternalHostGroup getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, ExternalHostGroup.class, ExternalHostProviderExternalHostGroup.class);
    }

    public List<ExternalHostProviderExternalHostGroup> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(this.parent.getHref() + "/" + this.getName());
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, ExternalHostGroups.class, ExternalHostProviderExternalHostGroup.class, headers);
    }
}

