/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.decorators.GroupPermissions;
import org.ovirt.engine.sdk.decorators.GroupRoles;
import org.ovirt.engine.sdk.decorators.GroupTags;
import org.ovirt.engine.sdk.entities.Response;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class Group
extends org.ovirt.engine.sdk.entities.Group {
    private HttpProxyBroker proxy;
    private final Object LOCK = new Object();
    private volatile GroupPermissions groupPermissions;
    private volatile GroupRoles groupRoles;
    private volatile GroupTags groupTags;

    public Group(HttpProxyBroker proxy) {
        this.proxy = proxy;
    }

    private HttpProxyBroker getProxy() {
        return this.proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupPermissions getPermissions() {
        if (this.groupPermissions == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.groupPermissions == null) {
                    this.groupPermissions = new GroupPermissions(this.proxy, this);
                }
            }
        }
        return this.groupPermissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GroupRoles getRoles() {
        if (this.groupRoles == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.groupRoles == null) {
                    this.groupRoles = new GroupRoles(this.proxy, this);
                }
            }
        }
        return this.groupRoles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupTags getTags() {
        if (this.groupTags == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.groupTags == null) {
                    this.groupTags = new GroupTags(this.proxy, this);
                }
            }
        }
        return this.groupTags;
    }

    public Response delete() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Response delete(Boolean async) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Response delete(Boolean async, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().delete(url, Response.class, headers);
    }
}

