/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.InstanceType;
import org.ovirt.engine.sdk.decorators.InstanceTypeWatchDog;
import org.ovirt.engine.sdk.entities.WatchDog;
import org.ovirt.engine.sdk.entities.WatchDogs;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class InstanceTypeWatchDogs
extends CollectionDecorator<WatchDog, WatchDogs, InstanceTypeWatchDog> {
    private InstanceType parent;

    public InstanceTypeWatchDogs(HttpProxyBroker proxy, InstanceType parent) {
        super(proxy, "watchdogs");
        this.parent = parent;
    }

    @Override
    public List<InstanceTypeWatchDog> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, WatchDogs.class, InstanceTypeWatchDog.class);
    }

    @Override
    public InstanceTypeWatchDog get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, WatchDog.class, InstanceTypeWatchDog.class);
    }

    @Override
    public InstanceTypeWatchDog getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, WatchDog.class, InstanceTypeWatchDog.class);
    }

    public InstanceTypeWatchDog add(WatchDog watchdog) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, watchdog, WatchDog.class, InstanceTypeWatchDog.class, headers);
    }

    public List<InstanceTypeWatchDog> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(this.parent.getHref() + "/" + this.getName());
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, WatchDogs.class, InstanceTypeWatchDog.class, headers);
    }
}

