/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.OpenStackNetworkProvider;
import org.ovirt.engine.sdk.decorators.OpenStackNetworkProviderOpenStackNetwork;
import org.ovirt.engine.sdk.entities.OpenStackNetwork;
import org.ovirt.engine.sdk.entities.OpenStackNetworks;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class OpenStackNetworkProviderOpenStackNetworks
extends CollectionDecorator<OpenStackNetwork, OpenStackNetworks, OpenStackNetworkProviderOpenStackNetwork> {
    private OpenStackNetworkProvider parent;

    public OpenStackNetworkProviderOpenStackNetworks(HttpProxyBroker proxy, OpenStackNetworkProvider parent) {
        super(proxy, "networks");
        this.parent = parent;
    }

    @Override
    public List<OpenStackNetworkProviderOpenStackNetwork> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, OpenStackNetworks.class, OpenStackNetworkProviderOpenStackNetwork.class);
    }

    @Override
    public OpenStackNetworkProviderOpenStackNetwork get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, OpenStackNetwork.class, OpenStackNetworkProviderOpenStackNetwork.class);
    }

    @Override
    public OpenStackNetworkProviderOpenStackNetwork getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, OpenStackNetwork.class, OpenStackNetworkProviderOpenStackNetwork.class);
    }

    public List<OpenStackNetworkProviderOpenStackNetwork> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(this.parent.getHref() + "/" + this.getName());
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, OpenStackNetworks.class, OpenStackNetworkProviderOpenStackNetwork.class, headers);
    }
}

