/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.StorageDomain;
import org.ovirt.engine.sdk.decorators.StorageDomainDiskProfile;
import org.ovirt.engine.sdk.entities.DiskProfile;
import org.ovirt.engine.sdk.entities.DiskProfiles;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class StorageDomainDiskProfiles
extends CollectionDecorator<DiskProfile, DiskProfiles, StorageDomainDiskProfile> {
    private StorageDomain parent;

    public StorageDomainDiskProfiles(HttpProxyBroker proxy, StorageDomain parent) {
        super(proxy, "diskprofiles");
        this.parent = parent;
    }

    @Override
    public List<StorageDomainDiskProfile> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, DiskProfiles.class, StorageDomainDiskProfile.class);
    }

    @Override
    public StorageDomainDiskProfile get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, DiskProfile.class, StorageDomainDiskProfile.class);
    }

    @Override
    public StorageDomainDiskProfile getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, DiskProfile.class, StorageDomainDiskProfile.class);
    }

    public StorageDomainDiskProfile add(DiskProfile diskprofile) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, diskprofile, DiskProfile.class, StorageDomainDiskProfile.class, headers);
    }

    public StorageDomainDiskProfile add(DiskProfile diskprofile, String expect) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, diskprofile, DiskProfile.class, StorageDomainDiskProfile.class, headers);
    }

    public StorageDomainDiskProfile add(DiskProfile diskprofile, String expect, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, diskprofile, DiskProfile.class, StorageDomainDiskProfile.class, headers);
    }

    public List<StorageDomainDiskProfile> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(this.parent.getHref() + "/" + this.getName());
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, DiskProfiles.class, StorageDomainDiskProfile.class, headers);
    }
}

