/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.AccessController;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.auth.callback.CallbackHandlerPolicyContextHandler;
import org.jboss.security.jacc.SubjectPolicyContextHandler;
import org.wildfly.common.Assert;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ClassLoadingAttributeDefinitions;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.jacc.ElytronPolicyConfigurationFactory;
import org.wildfly.security.authz.jacc.JaccDelegatingPolicy;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.KeyPairCredential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.PublicKeyCredential;
import org.wildfly.security.credential.SecretKeyCredential;
import org.wildfly.security.credential.X509CertificateChainPrivateCredential;
import org.wildfly.security.credential.X509CertificateChainPublicCredential;
import org.wildfly.security.manager.WildFlySecurityManager;

class PolicyDefinitions {
    private static final SimpleAttributeDefinition NAME_ATTRIBUTE_DEFINITION = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, false).setMinSize(1)).build();
    static final SimpleAttributeDefinition DEFAULT_POLICY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-policy", ModelType.STRING, true).setAllowExpression(false)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();

    PolicyDefinitions() {
    }

    static ResourceDefinition getPolicy() {
        final AttributeDefinition[] attributes = new AttributeDefinition[]{DEFAULT_POLICY, JaccPolicyDefinition.POLICIES, CustomPolicyDefinition.POLICIES};
        BaseAddHandler add = new BaseAddHandler((RuntimeCapability)Capabilities.POLICY_RUNTIME_CAPABILITY, attributes){

            protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
                String defaultPolicy = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)DEFAULT_POLICY, model);
                if (defaultPolicy == null) {
                    defaultPolicy = context.getCurrentAddressValue();
                }
                ServiceName serviceName = Capabilities.POLICY_RUNTIME_CAPABILITY.getCapabilityServiceName(Policy.class);
                InjectedValue policyProviderInjector = new InjectedValue();
                ServiceTarget serviceTarget = context.getServiceTarget();
                ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, this.createPolicyService((InjectedValue<Supplier<Policy>>)policyProviderInjector));
                Supplier policySupplier = PolicyDefinitions.getPolicyProvider(context, model, defaultPolicy, (ServiceBuilder<Policy>)serviceBuilder);
                policyProviderInjector.setValue(() -> 1.lambda$performRuntime$0((Supplier)policySupplier));
                serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
                if (!context.isBooting()) {
                    context.reloadRequired();
                }
            }

            private Service<Policy> createPolicyService(final InjectedValue<Supplier<Policy>> injector) {
                return new Service<Policy>(){
                    volatile Policy delegated;
                    volatile Policy policy;

                    public void start(StartContext context) throws StartException {
                        this.delegated = this.getPolicy();
                        this.policy = (Policy)((Supplier)injector.getValue()).get();
                        try {
                            this.setPolicy(this.policy);
                            this.policy.refresh();
                        }
                        catch (Exception cause) {
                            this.setPolicy(this.delegated);
                            throw ElytronSubsystemMessages.ROOT_LOGGER.failedToSetPolicy(this.policy, cause);
                        }
                    }

                    public void stop(StopContext context) {
                        this.setPolicy(this.delegated);
                    }

                    public Policy getValue() throws IllegalStateException, IllegalArgumentException {
                        return this.policy;
                    }

                    private void setPolicy(Policy policy) {
                        if (WildFlySecurityManager.isChecking()) {
                            AccessController.doPrivileged(this.setPolicyAction(policy));
                        } else {
                            this.setPolicyAction(policy).run();
                        }
                    }

                    private PrivilegedAction<Void> setPolicyAction(Policy policy) {
                        return () -> {
                            Policy.setPolicy(policy);
                            return null;
                        };
                    }

                    private Policy getPolicy() {
                        if (WildFlySecurityManager.isChecking()) {
                            return AccessController.doPrivileged(this.getPolicyAction());
                        }
                        return this.getPolicyAction().run();
                    }

                    private PrivilegedAction<Policy> getPolicyAction() {
                        return Policy::getPolicy;
                    }
                };
            }

            private static /* synthetic */ Supplier lambda$performRuntime$0(Supplier policySupplier) throws IllegalStateException, IllegalArgumentException {
                return policySupplier;
            }
        };
        return new SimpleResourceDefinition(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"policy"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("policy")).setAddHandler((OperationStepHandler)add).setRemoveHandler((OperationStepHandler)new ReloadRequiredRemoveStepHandler()).setAddRestartLevel(OperationEntry.Flag.RESTART_ALL_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_ALL_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.POLICY_RUNTIME_CAPABILITY})){

            public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
                ReloadRequiredWriteAttributeHandler write = new ReloadRequiredWriteAttributeHandler(attributes){

                    protected void finishModelStage(OperationContext context, ModelNode operation, final String attributeName, final ModelNode newValue, final ModelNode oldValue, final Resource resource) throws OperationFailedException {
                        context.addStep(new OperationStepHandler(){

                            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                                ModelNode model = resource.getModel();
                                String defaultPolicy = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)DEFAULT_POLICY, model);
                                if (defaultPolicy == null) {
                                    defaultPolicy = context.getCurrentAddressValue();
                                }
                                if ((attributeName.equals("jacc-policy") || attributeName.equals("custom-policy")) && PolicyDefinitions.checkPolicyProviderRemoved(context, defaultPolicy, newValue, oldValue)) {
                                    throw ElytronSubsystemMessages.ROOT_LOGGER.cannotRemoveDefaultPolicy(defaultPolicy);
                                }
                                PolicyDefinitions.getPolicyProvider(context, model, defaultPolicy, (ServiceBuilder<Policy>)null);
                            }
                        }, OperationContext.Stage.MODEL);
                    }
                };
                for (AttributeDefinition current : attributes) {
                    resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)write);
                }
            }
        };
    }

    private static boolean checkPolicyProviderRemoved(OperationContext context, String defaultPolicy, ModelNode newValue, ModelNode oldValue) throws OperationFailedException {
        if (PolicyDefinitions.getPoliciesNames(context, oldValue).contains(defaultPolicy)) {
            return !PolicyDefinitions.getPoliciesNames(context, newValue).contains(defaultPolicy);
        }
        return false;
    }

    private static List<String> getPoliciesNames(OperationContext context, ModelNode modelNode) throws OperationFailedException {
        ArrayList<String> policies = new ArrayList<String>();
        if (modelNode.isDefined()) {
            for (ModelNode policy : modelNode.asList()) {
                policies.add(ElytronExtension.asStringIfDefined(context, (AttributeDefinition)NAME_ATTRIBUTE_DEFINITION, policy));
            }
        }
        return policies;
    }

    private static Supplier<Policy> getPolicyProvider(OperationContext context, ModelNode model, String defaultPolicy, ServiceBuilder<Policy> serviceBuilder) throws OperationFailedException {
        HashMap<String, Supplier> policies = new HashMap<String, Supplier>();
        policies.computeIfAbsent(defaultPolicy, name -> {
            try {
                return PolicyDefinitions.configureJaccPolicy(context, model, name, serviceBuilder);
            }
            catch (OperationFailedException e) {
                throw new RuntimeException(e);
            }
        });
        policies.computeIfAbsent(defaultPolicy, name -> {
            try {
                return PolicyDefinitions.configureCustomPolicies(context, model, name);
            }
            catch (OperationFailedException e) {
                throw new RuntimeException(e);
            }
        });
        if (policies.isEmpty()) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.cannotFindPolicyProvider(defaultPolicy);
        }
        return (Supplier)policies.get(defaultPolicy);
    }

    private static Supplier<Policy> configureCustomPolicies(OperationContext context, ModelNode model, String defaultPolicy) throws OperationFailedException {
        ModelNode customPolicies = model.get("custom-policy");
        if (customPolicies.isDefined()) {
            for (ModelNode policyModel : customPolicies.asList()) {
                String name = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)CustomPolicyDefinition.NAME, policyModel);
                if (!defaultPolicy.equals(name)) continue;
                String className = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)CustomPolicyDefinition.CLASS_NAME, policyModel);
                String module = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)CustomPolicyDefinition.MODULE, policyModel);
                return () -> PolicyDefinitions.newPolicy(className, module);
            }
        }
        return null;
    }

    private static Supplier<Policy> configureJaccPolicy(OperationContext context, ModelNode model, String defaultPolicy, ServiceBuilder<Policy> serviceBuilder) throws OperationFailedException {
        ModelNode jaccPolicies = model.get("jacc-policy");
        if (jaccPolicies.isDefined()) {
            for (ModelNode policyModel : jaccPolicies.asList()) {
                String name = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)JaccPolicyDefinition.NAME, policyModel);
                if (!defaultPolicy.equals(name)) continue;
                final String policyProvider = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)JaccPolicyDefinition.POLICY_PROVIDER, policyModel);
                final String configurationFactory = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)JaccPolicyDefinition.CONFIGURATION_FACTORY, policyModel);
                final String module = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)JaccPolicyDefinition.MODULE, policyModel);
                if (serviceBuilder != null) {
                    serviceBuilder.addAliases(new ServiceName[]{Capabilities.JACC_POLICY_RUNTIME_CAPABILITY.getCapabilityServiceName()});
                }
                return new Supplier<Policy>(){

                    @Override
                    public Policy get() {
                        if (configurationFactory != null) {
                            if (WildFlySecurityManager.isChecking()) {
                                AccessController.doPrivileged(this.setConfigurationProviderSystemProperty());
                            } else {
                                this.setConfigurationProviderSystemProperty().run();
                            }
                        }
                        Policy policy = PolicyDefinitions.newPolicy(policyProvider, module);
                        try {
                            PolicyContext.registerHandler((String)"javax.security.auth.Subject.container", (PolicyContextHandler)this.createSubjectPolicyContextHandler(), (boolean)true);
                            PolicyContext.registerHandler((String)"org.jboss.security.auth.spi.CallbackHandler", (PolicyContextHandler)this.createCallbackHandlerContextHandler(), (boolean)true);
                            PolicyContext.registerHandler((String)SecurityIdentity.class.getName(), (PolicyContextHandler)this.createSecurityIdentityContextHandler(), (boolean)true);
                        }
                        catch (PolicyContextException cause) {
                            throw ElytronSubsystemMessages.ROOT_LOGGER.failedToRegisterPolicyHandlers((Exception)((Object)cause));
                        }
                        return policy;
                    }

                    private PrivilegedAction<Void> setConfigurationProviderSystemProperty() {
                        return () -> {
                            if (WildFlySecurityManager.isChecking()) {
                                WildFlySecurityManager.setPropertyPrivileged((String)"javax.security.jacc.PolicyConfigurationFactory.provider", (String)configurationFactory);
                            } else {
                                System.setProperty("javax.security.jacc.PolicyConfigurationFactory.provider", configurationFactory);
                            }
                            return null;
                        };
                    }

                    private PolicyContextHandler createSecurityIdentityContextHandler() {
                        return new PolicyContextHandler(){
                            final String KEY = SecurityIdentity.class.getName();

                            public Object getContext(String key, Object data) throws PolicyContextException {
                                if (this.supports(key)) {
                                    SecurityDomain securityDomain = SecurityDomain.getCurrent();
                                    if (securityDomain == null) {
                                        return null;
                                    }
                                    SecurityIdentity securityIdentity = securityDomain.getCurrentSecurityIdentity();
                                    if (securityIdentity != null) {
                                        return securityIdentity;
                                    }
                                }
                                return null;
                            }

                            public String[] getKeys() throws PolicyContextException {
                                return new String[]{this.KEY};
                            }

                            public boolean supports(String key) throws PolicyContextException {
                                return this.getKeys()[0].equalsIgnoreCase(key);
                            }
                        };
                    }

                    private PolicyContextHandler createCallbackHandlerContextHandler() {
                        return new PolicyContextHandler(){
                            CallbackHandlerPolicyContextHandler legacy = new CallbackHandlerPolicyContextHandler();

                            public Object getContext(String key, Object data) throws PolicyContextException {
                                return this.legacy.getContext(key, data);
                            }

                            public String[] getKeys() throws PolicyContextException {
                                return this.legacy.getKeys();
                            }

                            public boolean supports(String key) throws PolicyContextException {
                                return this.legacy.supports(key);
                            }
                        };
                    }

                    private PolicyContextHandler createSubjectPolicyContextHandler() {
                        return new PolicyContextHandler(){
                            SubjectPolicyContextHandler legacy = new SubjectPolicyContextHandler();

                            public Object getContext(String key, Object data) throws PolicyContextException {
                                if (this.supports(key)) {
                                    SecurityIdentity securityIdentity = (SecurityIdentity)PolicyContext.getContext((String)SecurityIdentity.class.getName());
                                    if (securityIdentity == null) {
                                        return this.legacy.getContext(key, data);
                                    }
                                    return SubjectUtil.fromSecurityIdentity(securityIdentity);
                                }
                                return null;
                            }

                            public String[] getKeys() throws PolicyContextException {
                                return this.legacy.getKeys();
                            }

                            public boolean supports(String key) throws PolicyContextException {
                                return this.legacy.supports(key);
                            }
                        };
                    }
                };
            }
        }
        return null;
    }

    private static Policy newPolicy(String className, String module) {
        try {
            ClassLoader classLoader = ClassLoadingAttributeDefinitions.resolveClassLoader(module);
            Object policy = classLoader.loadClass(className).newInstance();
            return (Policy)Policy.class.cast(policy);
        }
        catch (Exception e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.failedToCreatePolicy(className, e);
        }
    }

    static /* synthetic */ SimpleAttributeDefinition access$000() {
        return NAME_ATTRIBUTE_DEFINITION;
    }

    static final class SubjectUtil {
        SubjectUtil() {
        }

        public static Subject fromSecurityIdentity(SecurityIdentity securityIdentity) {
            Assert.checkNotNullParam((String)"securityIdentity", (Object)securityIdentity);
            Subject subject = new Subject();
            subject.getPrincipals().add(securityIdentity.getPrincipal());
            SimpleGroup rolesGroup = new SimpleGroup("Roles");
            for (String role : securityIdentity.getRoles()) {
                rolesGroup.addMember((Principal)new NamePrincipal(role));
            }
            subject.getPrincipals().add((Principal)((Object)rolesGroup));
            SimpleGroup callerPrincipalGroup = new SimpleGroup("CallerPrincipal");
            callerPrincipalGroup.addMember(securityIdentity.getPrincipal());
            subject.getPrincipals().add((Principal)((Object)callerPrincipalGroup));
            for (Credential credential : securityIdentity.getPublicCredentials()) {
                if (credential instanceof PublicKeyCredential) {
                    subject.getPublicCredentials().add(((PublicKeyCredential)credential.castAs(PublicKeyCredential.class)).getPublicKey());
                    continue;
                }
                if (credential instanceof X509CertificateChainPublicCredential) {
                    subject.getPublicCredentials().add(((X509CertificateChainPublicCredential)credential.castAs(X509CertificateChainPublicCredential.class)).getCertificateChain());
                    continue;
                }
                subject.getPublicCredentials().add(credential);
            }
            for (Credential credential : securityIdentity.getPrivateCredentials()) {
                if (credential instanceof PasswordCredential) {
                    SubjectUtil.addPrivateCredential(subject, ((PasswordCredential)credential.castAs(PasswordCredential.class)).getPassword());
                    continue;
                }
                if (credential instanceof SecretKeyCredential) {
                    SubjectUtil.addPrivateCredential(subject, ((SecretKeyCredential)credential.castAs(SecretKeyCredential.class)).getSecretKey());
                    continue;
                }
                if (credential instanceof KeyPairCredential) {
                    SubjectUtil.addPrivateCredential(subject, ((KeyPairCredential)credential.castAs(KeyPairCredential.class)).getKeyPair());
                    continue;
                }
                if (credential instanceof X509CertificateChainPrivateCredential) {
                    SubjectUtil.addPrivateCredential(subject, ((X509CertificateChainPrivateCredential)credential.castAs(X509CertificateChainPrivateCredential.class)).getCertificateChain());
                    continue;
                }
                SubjectUtil.addPrivateCredential(subject, credential);
            }
            SubjectUtil.addPrivateCredential(subject, securityIdentity);
            return subject;
        }

        static void addPrivateCredential(Subject subject, Object credential) {
            if (!WildFlySecurityManager.isChecking()) {
                subject.getPrivateCredentials().add(credential);
            } else {
                AccessController.doPrivileged(() -> {
                    subject.getPrivateCredentials().add(credential);
                    return null;
                });
            }
        }

        private static class SimpleGroup
        implements Group {
            private final String name;
            private final Set<Principal> principals;

            SimpleGroup(String name) {
                this.name = name;
                this.principals = new HashSet<Principal>();
            }

            public String getName() {
                return this.name;
            }

            public boolean addMember(Principal principal) {
                return this.principals.add(principal);
            }

            public boolean removeMember(Principal principal) {
                return this.principals.remove(principal);
            }

            public Enumeration<? extends Principal> members() {
                return Collections.enumeration(this.principals);
            }

            public boolean isMember(Principal principal) {
                return this.principals.contains(principal);
            }
        }
    }

    static class CustomPolicyDefinition {
        static final SimpleAttributeDefinition NAME = PolicyDefinitions.access$000();
        static final SimpleAttributeDefinition CLASS_NAME = ClassLoadingAttributeDefinitions.CLASS_NAME;
        static final SimpleAttributeDefinition MODULE = ClassLoadingAttributeDefinitions.MODULE;
        static ObjectTypeAttributeDefinition POLICY = new ObjectTypeAttributeDefinition.Builder("custom-policy", new AttributeDefinition[]{NAME, CLASS_NAME, MODULE}).build();
        static final ObjectListAttributeDefinition POLICIES = ((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("custom-policy", POLICY).setRequired(false)).build();

        CustomPolicyDefinition() {
        }
    }

    static class JaccPolicyDefinition {
        static final SimpleAttributeDefinition NAME = PolicyDefinitions.access$000();
        static final SimpleAttributeDefinition POLICY_PROVIDER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("policy", ModelType.STRING, true).setDefaultValue(new ModelNode(JaccDelegatingPolicy.class.getName()))).setMinSize(1)).build();
        static final SimpleAttributeDefinition CONFIGURATION_FACTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("configuration-factory", ModelType.STRING, true).setDefaultValue(new ModelNode(ElytronPolicyConfigurationFactory.class.getName()))).setMinSize(1)).build();
        static final SimpleAttributeDefinition MODULE = ClassLoadingAttributeDefinitions.MODULE;
        static ObjectTypeAttributeDefinition POLICY = new ObjectTypeAttributeDefinition.Builder("jacc-policy", new AttributeDefinition[]{NAME, POLICY_PROVIDER, CONFIGURATION_FACTORY, MODULE}).build();
        static final ObjectListAttributeDefinition POLICIES = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("jacc-policy", POLICY).setMinSize(1)).setRequired(false)).build();

        JaccPolicyDefinition() {
        }
    }
}

