/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.naming;

import java.net.URI;
import java.util.ArrayList;
import javax.naming.NamingException;
import org.wildfly.httpclient.naming.HttpNamingClientMessages;
import org.wildfly.httpclient.naming.HttpNamingProvider;
import org.wildfly.naming.client.NamingProvider;
import org.wildfly.naming.client.NamingProviderFactory;
import org.wildfly.naming.client.util.FastHashtable;

public class HttpNamingProviderFactory
implements NamingProviderFactory {
    public boolean supportsUriScheme(String providerScheme, FastHashtable<String, Object> env) {
        switch (providerScheme) {
            case "http": 
            case "https": {
                return true;
            }
        }
        return false;
    }

    public NamingProvider createProvider(FastHashtable<String, Object> env, URI ... providerUris) throws NamingException {
        if (providerUris.length == 0) {
            throw HttpNamingClientMessages.MESSAGES.atLeastOneUri();
        }
        ArrayList<NamingProvider.Location> locationList = new ArrayList<NamingProvider.Location>();
        for (URI uri : providerUris) {
            locationList.add(NamingProvider.Location.of((URI)uri));
        }
        return new HttpNamingProvider(locationList, env);
    }
}

