/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.interposition;

import com.arjuna.ats.internal.jts.interposition.FactoryCreator;
import com.arjuna.ats.internal.jts.interposition.FactoryElement;
import com.arjuna.ats.internal.jts.interposition.resources.arjuna.InterpositionCreator;
import com.arjuna.ats.internal.jts.interposition.resources.osi.OSIInterpositionCreator;
import com.arjuna.ats.internal.jts.interposition.resources.restricted.RestrictedInterpositionCreator;
import com.arjuna.ats.internal.jts.interposition.resources.strict.StrictInterpositionCreator;
import com.arjuna.ats.internal.jts.orbspecific.ControlImple;
import com.arjuna.ats.jts.extensions.Arjuna;
import com.arjuna.ats.jts.logging.jtsLogger;
import java.util.concurrent.locks.ReentrantLock;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.SystemException;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.PropagationContext;

public class FactoryList {
    public static final int DEFAULT_ID = 0;
    private static FactoryElement _list = null;
    private static FactoryElement _default = null;
    private static ReentrantLock _lock = new ReentrantLock();

    public FactoryList() {
        FactoryList.add(new InterpositionCreator(), Arjuna.XID());
        FactoryList.add(new StrictInterpositionCreator(), Arjuna.strictXID());
        FactoryList.add(new RestrictedInterpositionCreator(), Arjuna.restrictedXID());
        FactoryList.add(new OSIInterpositionCreator(), 0);
        FactoryList.addDefault(new OSIInterpositionCreator(), 0);
    }

    public static ControlImple recreateLocal(PropagationContext ctx, int formatID) throws SystemException {
        ControlImple toReturn = null;
        if (ctx == null) {
            throw new INVALID_TRANSACTION();
        }
        FactoryElement ptr = FactoryList.find(formatID);
        if (ptr != null) {
            toReturn = ptr.recreateLocal(ctx);
        }
        return toReturn;
    }

    public static Control recreate(PropagationContext ctx, int formatID) throws SystemException {
        Control toReturn = null;
        if (ctx == null) {
            throw new INVALID_TRANSACTION();
        }
        FactoryElement ptr = FactoryList.find(formatID);
        if (ptr != null) {
            toReturn = ptr.recreate(ctx);
        }
        return toReturn;
    }

    public static void add(FactoryCreator create, int formatID) {
        FactoryElement ptr = FactoryList.find(formatID);
        _lock.lock();
        if (ptr == null) {
            ptr = new FactoryElement(create, formatID);
            ptr._next = _list;
            _list = ptr;
        }
        _lock.unlock();
    }

    public static void remove(int formatID) {
        _lock.lock();
        FactoryElement ptr = _list;
        FactoryElement trail = null;
        boolean found = false;
        while (ptr != null && !found) {
            if (ptr._formatID == formatID) {
                found = true;
                continue;
            }
            trail = ptr;
            ptr = ptr._next;
        }
        if (found) {
            if (_list == ptr) {
                _list = ptr._next;
            } else if (trail != null) {
                trail._next = ptr._next;
            }
            ptr._next = null;
            ptr = null;
        }
        _lock.unlock();
    }

    public static boolean addDefault(FactoryCreator create, int formatID) {
        boolean res = false;
        _lock.lock();
        if (_default == null) {
            _default = new FactoryElement(create, formatID);
            res = true;
        } else {
            jtsLogger.i18NLogger.warn_interposition_fldefault("FactoryList.addDefault");
        }
        _lock.unlock();
        return res;
    }

    public static boolean removeDefault() {
        boolean found = false;
        _lock.lock();
        if (_default != null) {
            _default = null;
            found = true;
        }
        _lock.unlock();
        return found;
    }

    protected static FactoryElement find(int formatID) {
        FactoryElement ptr = _list;
        FactoryElement toReturn = null;
        _lock.lock();
        while (ptr != null && toReturn == null) {
            if (ptr._formatID == formatID) {
                toReturn = ptr;
                continue;
            }
            ptr = ptr._next;
        }
        if (toReturn == null) {
            toReturn = _default;
        }
        _lock.unlock();
        return toReturn;
    }
}

