/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.builtin.time.impl;

import java.time.Instant;
import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.builtin.time.impl.NumericTimeBridge;
import org.hibernate.search.metadata.NumericFieldSettingsDescriptor;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class InstantBridge
implements TwoWayFieldBridge,
NumericTimeBridge {
    private static final Log log = LoggerFactory.make();
    public static final InstantBridge INSTANCE = new InstantBridge();

    @Override
    public NumericFieldSettingsDescriptor.NumericEncodingType getEncodingType() {
        return NumericFieldSettingsDescriptor.NumericEncodingType.LONG;
    }

    @Override
    public Object get(String name, Document document) {
        String millisFromEpoch = document.get(name);
        return Instant.ofEpochMilli(Long.valueOf(millisFromEpoch));
    }

    @Override
    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (value != null) {
            Long nanos = this.toEpochMillis((Instant)value);
            luceneOptions.addNumericFieldToDocument(name, nanos, document);
        }
    }

    @Override
    public String objectToString(Object object) {
        if (object == null) {
            return null;
        }
        Instant instant = (Instant)object;
        return String.valueOf(this.toEpochMillis(instant));
    }

    private Long toEpochMillis(Instant value) {
        try {
            Long millis = value.toEpochMilli();
            return millis;
        }
        catch (ArithmeticException ae) {
            throw log.valueTooLargeForConversionException(Instant.class, value, ae);
        }
    }
}

