/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.access;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.infinispan.commands.LocalFlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.locking.NonTransactionalLockingInterceptor;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class LockingInterceptor
extends NonTransactionalLockingInterceptor {
    private static final Log log = LogFactory.getLog(LockingInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();

    protected Object visitDataWriteCommand(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        Object returnValue = null;
        try {
            command.setMetadata(null);
            this.lockAndRecord(ctx, command.getKey(), this.getLockTimeoutMillis((LocalFlagAffectedCommand)command));
            Object object = returnValue = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
            return object;
        }
        catch (TimeoutException e) {
            if (!ctx.isOriginLocal() && command.hasFlag(Flag.ZERO_LOCK_ACQUISITION_TIMEOUT)) {
                if (trace) {
                    log.tracef("Silently ignoring exception", (Object)e);
                }
                Object var5_7 = null;
                return var5_7;
            }
            throw e;
        }
        finally {
            this.lockManager.unlockAll(ctx);
            if (returnValue instanceof CompletableFuture) {
                try {
                    ((CompletableFuture)returnValue).join();
                }
                catch (CompletionException e) {
                    throw e.getCause();
                }
            }
        }
    }
}

