/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.compensations.internal;

import com.arjuna.mw.wscf.protocols.ProtocolRegistry;
import org.jboss.narayana.compensations.internal.BAController;
import org.jboss.narayana.compensations.internal.local.LocalBAController;
import org.jboss.narayana.compensations.internal.remote.RemoteBAController;

public class BAControllerFactory {
    public static BAController getInstance() {
        BAController remoteBAController = BAControllerFactory.getRemoteInstance();
        if (remoteBAController.isBARunning()) {
            return remoteBAController;
        }
        BAController localBAController = BAControllerFactory.getLocalInstance();
        if (localBAController.isBARunning()) {
            return localBAController;
        }
        return localBAController;
    }

    public static BAController getRemoteInstance() {
        return new RemoteBAController();
    }

    public static BAController getLocalInstance() {
        ProtocolRegistry.sharedManager().initialise();
        return new LocalBAController();
    }

    public static boolean isLocalTransactionRunning() {
        if (BAControllerFactory.getRemoteInstance().isBARunning()) {
            return false;
        }
        BAController localBAController = BAControllerFactory.getLocalInstance();
        return localBAController.isBARunning();
    }

    public static boolean isRemoteTransactionRunning() {
        return BAControllerFactory.getRemoteInstance().isBARunning();
    }
}

