/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.wildfly.common.Assert;

public interface DeploymentNodeSelector {
    public static final DeploymentNodeSelector FIRST = (eligibleNodes, appName, moduleName, distinctName) -> eligibleNodes[0];
    public static final DeploymentNodeSelector RANDOM = (eligibleNodes, appName, moduleName, distinctName) -> eligibleNodes[ThreadLocalRandom.current().nextInt(eligibleNodes.length)];
    public static final DeploymentNodeSelector ROUND_ROBIN = new DeploymentNodeSelector(){
        private final AtomicInteger counter = new AtomicInteger();

        @Override
        public String selectNode(String[] eligibleNodes, String appName, String moduleName, String distinctName) {
            int length = eligibleNodes.length;
            assert (length > 0);
            return eligibleNodes[Math.floorMod(this.counter.getAndIncrement(), length)];
        }
    };

    public String selectNode(String[] var1, String var2, String var3, String var4);

    public static DeploymentNodeSelector favorite(Collection<String> favorites, DeploymentNodeSelector fallback) {
        Assert.checkNotNullParam((String)"favorites", favorites);
        Assert.checkNotNullParam((String)"fallback", (Object)fallback);
        return (eligibleNodes, appName, moduleName, distinctName) -> {
            HashSet set = new HashSet(eligibleNodes.length);
            Collections.addAll(set, eligibleNodes);
            for (String favorite : favorites) {
                if (!set.contains(favorite)) continue;
                return favorite;
            }
            return fallback.selectNode(eligibleNodes, appName, moduleName, distinctName);
        };
    }
}

